/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.time.Duration;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSourceImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import moe.plushie.armourers_workshop.core.data.cache.CacheQueue;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class AbstractBufferSource
implements IBufferSource {
    private static final AbstractBufferSource DEFAULT = AbstractBufferSource.create(AbstractBufferSourceImpl::bufferSource);
    private static final AbstractBufferSource OUTLINE = AbstractBufferSource.create(AbstractBufferSourceImpl::outlineBufferSource);
    private static final AbstractBufferSource TESSELATOR = AbstractBufferSource.create(80000);
    private static final CacheQueue<Object, AbstractBufferSource> CACHED_BUFFER_SOURCES = new CacheQueue(Duration.ofSeconds(30L));
    private static final CacheQueue<class_4588, IVertexConsumer> CACHED_BUFFER_BUILDERS = new CacheQueue(Duration.ofSeconds(30L));
    private final Supplier<class_4597> bufferSourceProvider;

    private AbstractBufferSource(Supplier<class_4597> bufferSourceProvider) {
        this.bufferSourceProvider = bufferSourceProvider;
    }

    public static AbstractBufferSource buffer() {
        return DEFAULT;
    }

    public static AbstractBufferSource outline() {
        return OUTLINE;
    }

    public static AbstractBufferSource tesselator() {
        return TESSELATOR;
    }

    public static AbstractBufferSource create(int size) {
        return AbstractBufferSource.create(AbstractBufferSourceImpl.immediateSource(size));
    }

    public static AbstractBufferSource create(class_4597 bufferSource) {
        return AbstractBufferSource.create(() -> bufferSource);
    }

    public static AbstractBufferSource create(Supplier<class_4597> bufferSourceProvider) {
        return new AbstractBufferSource(bufferSourceProvider);
    }

    public static AbstractBufferSource wrap(class_4597 bufferSource) {
        AbstractBufferSource bufferSource1 = CACHED_BUFFER_SOURCES.get(bufferSource);
        if (bufferSource1 == null) {
            bufferSource1 = AbstractBufferSource.create(bufferSource);
            CACHED_BUFFER_SOURCES.put(bufferSource, bufferSource1);
        }
        return bufferSource1;
    }

    public static class_4597 unwrap(IBufferSource bufferSource) {
        return ((AbstractBufferSource)bufferSource).bufferSource();
    }

    @Override
    public IVertexConsumer getBuffer(IRenderType renderType) {
        class_4588 builder = this.bufferSource().getBuffer((class_1921)renderType.get());
        return CACHED_BUFFER_BUILDERS.computeIfAbsent(builder, AbstractVertexConsumer::of);
    }

    @Override
    public void endBatch() {
        class_4597 class_45972 = this.bufferSource();
        if (class_45972 instanceof class_4597.class_4598) {
            class_4597.class_4598 bufferSource1 = (class_4597.class_4598)class_45972;
            bufferSource1.method_22993();
        }
    }

    public class_4597 bufferSource() {
        return this.bufferSourceProvider.get();
    }
}

