/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.RenderType.ColorLogicProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4668;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class AbstractRenderTypeImpl
extends class_1921 {
    private static final Map<SkinVertexFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderTypeImpl._make(it -> {
        it.put(SkinVertexFormat.LINE, () -> AbstractRenderTypeImpl._builder(class_290.field_1576, class_293.class_5596.field_29344, field_29442));
        it.put(SkinVertexFormat.LINE_STRIP, () -> AbstractRenderTypeImpl._builder(class_290.field_1576, class_293.class_5596.field_29345, field_29442));
        it.put(SkinVertexFormat.IMAGE, () -> AbstractRenderTypeImpl._builder(class_290.field_20888, class_293.class_5596.field_27382, field_29441).overlay().lightmap());
        it.put(SkinVertexFormat.BLIT_MASK, () -> AbstractRenderTypeImpl._builder(class_290.field_1576, class_293.class_5596.field_27379, field_29442));
        it.put(SkinVertexFormat.GUI_COLOR, () -> AbstractRenderTypeImpl._builder(class_290.field_1576, class_293.class_5596.field_27382, field_29442));
        it.put(SkinVertexFormat.GUI_IMAGE, () -> AbstractRenderTypeImpl._builder(class_290.field_1585, class_293.class_5596.field_27382, field_29440));
        it.put(SkinVertexFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderTypeImpl._builder(class_290.field_1592, class_293.class_5596.field_27382, field_29438));
        it.put(SkinVertexFormat.BLOCK, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29450));
        it.put(SkinVertexFormat.BLOCK_CUTOUT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29451));
        it.put(SkinVertexFormat.ENTITY_CUTOUT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29451));
        it.put(SkinVertexFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29452));
        it.put(SkinVertexFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29406));
        it.put(SkinVertexFormat.ENTITY_ALPHA, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29413));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29450).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29412).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29450).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29412).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29451).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29415).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29450).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27382, field_29415).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27379, field_29451).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27379, field_29415).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27379, field_29450).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(class_290.field_1580, class_293.class_5596.field_27379, field_29415).overlay().lightmap().emissive());
    });

    public AbstractRenderTypeImpl(String name, class_1921 delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.method_23031(), delegate.method_23033(), delegate.method_22722(), affectsCrumbling, sortUpload, () -> {
            delegate.method_23516();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.method_23518();
        });
    }

    public static IRenderTypeBuilder builder(SkinVertexFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            IRenderTypeBuilder builder = provider.get();
            if (builder instanceof Builder) {
                Builder builder1 = (Builder)builder;
                builder1.format(format);
            }
            return builder;
        }
        throw new RuntimeException("can't supported render mode");
    }

    private static Builder _builder(class_293 format, class_293.class_5596 mode, class_4668.class_5942 shader) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder.method_34578(shader);
        return builder;
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    extends AbstractRenderType.Builder {
        private static final Map<IRenderType.Texturing, class_4668.class_4684> TABLE_TEXTURING = AbstractRenderTypeImpl._make(it -> {});
        private static final Map<IRenderType.Target, class_4668.class_4678> TABLE_OUTPUT = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Target.MAIN, field_21358);
            it.put(IRenderType.Target.OUTLINE, field_21359);
            it.put(IRenderType.Target.TRANSLUCENT, field_25280);
            it.put(IRenderType.Target.CLOUDS, field_25283);
            it.put(IRenderType.Target.WEATHER, field_25282);
            it.put(IRenderType.Target.PARTICLES, field_25281);
            it.put(IRenderType.Target.ITEM_ENTITY, field_25643);
        });
        private static final Map<IRenderType.Transparency, class_4668.class_4685> TABLE_TRANSPARENCY = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Transparency.DEFAULT, field_21370);
            it.put(IRenderType.Transparency.TRANSLUCENT, field_21370);
            it.put(IRenderType.Transparency.NONE, field_21364);
        });
        private static final Map<IRenderType.WriteMask, class_4668.class_4686> TABLE_WRITE_MASK = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.WriteMask.NONE, new class_4668.class_4686(false, false));
            it.put(IRenderType.WriteMask.COLOR_DEPTH_WRITE, field_21349);
            it.put(IRenderType.WriteMask.COLOR_WRITE, field_21350);
            it.put(IRenderType.WriteMask.DEPTH_WRITE, field_21351);
        });
        private static final Map<IRenderType.DepthTest, class_4668.class_4672> TABLE_DEPTH_TEST = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.DepthTest.NONE, field_21346);
            it.put(IRenderType.DepthTest.EQUAL, field_21347);
            it.put(IRenderType.DepthTest.LESS_EQUAL, field_21348);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        class_1921.class_4688.class_4689 stateBuilder = class_1921.class_4688.method_23598();
        final class_293 format;
        final class_293.class_5596 mode;

        private Builder(class_293 format, class_293.class_5596 mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            this.stateBuilder = this.stateBuilder.method_23603(field_21345);
        }

        @Override
        public IRenderTypeBuilder texture(IResourceLocation texture, boolean blur, boolean mipmap) {
            this.stateBuilder = this.stateBuilder.method_34577((class_4668.class_5939)new class_4668.class_4683(texture.toLocation(), blur, mipmap));
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderType.Texturing texturing) {
            this.stateBuilder = this.stateBuilder.method_23614(TABLE_TEXTURING.getOrDefault((Object)texturing, field_21379));
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderType.Target target) {
            this.stateBuilder = this.stateBuilder.method_23610(TABLE_OUTPUT.getOrDefault((Object)target, field_21358));
            return super.target(target);
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderType.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.method_23615(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, field_21364));
            return super.transparency(transparency);
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderType.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.method_23616(TABLE_WRITE_MASK.getOrDefault((Object)mask, field_21349));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderType.DepthTest test) {
            this.stateBuilder = this.stateBuilder.method_23604(TABLE_DEPTH_TEST.getOrDefault((Object)test, field_21346));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderType.ColorLogic state) {
            this.stateBuilder = ColorLogicProvider.CompositeState.CompositeStateBuilder.setColorLogicState(this.stateBuilder, state);
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.method_23607(new class_4668.class_4675("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.method_23609(new class_4668.class_4677(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.method_23607(new class_4668.class_4675("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.method_23603(field_21344);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.method_23608(field_21383);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.method_23611(field_21385);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public IRenderType build(String name) {
            AbstractRenderType renderType = AbstractRenderType.of((class_1921)class_1921.method_24049((String)name, (class_293)this.format, (class_293.class_5596)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (class_1921.class_4688)this.stateBuilder.method_23617(this.isOutline)));
            renderType.apply(this.updater);
            return renderType;
        }

        public Builder or(Function<class_1921.class_4688.class_4689, class_1921.class_4688.class_4689> builder) {
            this.stateBuilder = builder.apply(this.stateBuilder);
            return this;
        }
    }
}

