/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.EntityRendererImpl;
import com.apple.library.uikit.UIFont;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRendererImpl;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreenImpl;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private static final IBufferSource SHARED_BUFFERS = AbstractBufferSource.create(256);
    private final IPoseStack poseStack;
    private final class_4587 originPoseStack;
    private final CGPoint mousePos;
    private final float partialTicks;
    private final AbstractMenuScreenImpl<?> screen;

    public AbstractGraphicsRenderer(AbstractMenuScreenImpl<?> screen, class_4587 poseStack, float mouseX, float mouseY, float partialTicks) {
        this.screen = screen;
        this.originPoseStack = poseStack;
        this.poseStack = AbstractPoseStack.wrap(poseStack);
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static class_4587 of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)Objects.unsafeCast(context.state());
        return impl.originPoseStack;
    }

    public static CGGraphicsContext of(AbstractMenuScreenImpl<?> screen, class_4587 poseStack, float mouseX, float mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(screen, poseStack, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, UIFont font, CGGraphicsContext context) {
        List texts = font.impl().method_1728((class_5348)text.component(), 100000);
        this.screen._renderTooltip(this.originPoseStack, texts, (int)this.mousePos.x, (int)this.mousePos.y);
    }

    @Override
    public void renderTooltip(class_1799 itemStack, CGRect rect, UIFont font, CGGraphicsContext context) {
        this.screen._renderTooltip(this.originPoseStack, itemStack, (int)this.mousePos.x, (int)this.mousePos.y);
    }

    @Override
    public void renderEntity(class_1297 entity, CGPoint origin, int scale, CGPoint focus, CGGraphicsContext context) {
        EntityRendererImpl<class_1297> renderer = AbstractGraphicsRendererImpl.getRenderer(entity);
        renderer.render(entity, origin, scale, focus, context);
    }

    @Override
    public void renderItem(class_1799 itemStack, int x, int y, CGGraphicsContext context) {
        class_310.method_1551().method_1480().method_27953(itemStack, x, y);
    }

    @Override
    public void flush() {
        SHARED_BUFFERS.endBatch();
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public IBufferSource bufferSource() {
        return SHARED_BUFFERS;
    }

    @Override
    public IPoseStack ctm() {
        return this.poseStack;
    }
}

