/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.Arrays;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;

public class ArmatureTransformer {
    private final Armature armature;
    private final ArmaturePlugin[] plugins;
    private final IJointTransform[] transforms;
    private final ArmatureTransformerContext context;

    public ArmatureTransformer(Armature armature, Collection<ArmaturePlugin> plugins, ArmatureTransformerContext context) {
        this.armature = armature;
        this.plugins = plugins.toArray(new ArmaturePlugin[0]);
        this.transforms = new IJointTransform[armature.size()];
        this.context = context;
        Arrays.fill(this.transforms, IJointTransform.NONE);
    }

    public void put(IJoint joint, IJointTransform transform) {
        this.transforms[joint.id()] = transform;
    }

    public Armature armature() {
        return this.armature;
    }

    public ArmaturePlugin[] plugins() {
        return this.plugins;
    }

    public IJointTransform[] transforms() {
        return this.transforms;
    }

    public ArmatureTransformerContext context() {
        return this.context;
    }
}

