/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4608;

public class EntitySlot {
    protected final class_1799 itemStack;
    protected final SkinDescriptor descriptor;
    protected final BakedSkin bakedSkin;
    protected final SkinPaintScheme bakedScheme;
    protected final Type slotType;
    protected final float renderPriority;
    protected final boolean useOverlayColor;

    public EntitySlot(class_1799 itemStack, SkinDescriptor descriptor, BakedSkin bakedSkin, SkinPaintScheme entityScheme, float renderPriority, Type slotType) {
        this.itemStack = itemStack;
        this.descriptor = descriptor;
        this.bakedSkin = bakedSkin;
        this.bakedScheme = EntitySlot.baking(descriptor.paintScheme(), entityScheme, slotType);
        this.renderPriority = renderPriority;
        this.slotType = slotType;
        this.useOverlayColor = bakedSkin.properties().get(SkinProperty.USE_OVERLAY_COLOR);
    }

    public static SkinPaintScheme baking(SkinPaintScheme skinScheme, SkinPaintScheme entityScheme, Type slotType) {
        if (slotType == Type.IN_HELD) {
            return skinScheme;
        }
        if (skinScheme.isEmpty()) {
            return entityScheme;
        }
        if (entityScheme.isEmpty()) {
            return skinScheme;
        }
        SkinPaintScheme bakedScheme = skinScheme.copy();
        bakedScheme.setReference(entityScheme);
        return bakedScheme;
    }

    public boolean shouldRenderInHeld(class_1799 itemStack) {
        return this.descriptor.accept(itemStack);
    }

    public float renderPriority() {
        return this.renderPriority;
    }

    public BakedSkin skin() {
        return this.bakedSkin;
    }

    public SkinType skinType() {
        return this.bakedSkin.type();
    }

    public Type slotType() {
        return this.slotType;
    }

    public SkinPaintScheme paintScheme() {
        return this.bakedScheme;
    }

    public SkinDescriptor descriptor() {
        return this.descriptor;
    }

    public class_1799 itemStack() {
        return this.itemStack;
    }

    public int getOverrideOverlay(class_1297 entity) {
        if (!this.useOverlayColor || !(entity instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 livingEntity = (class_1309)entity;
        int u = class_4608.method_23210((float)0.0f);
        int v = class_4608.method_23212((livingEntity.field_6235 > 0 || livingEntity.field_6213 > 0 ? 1 : 0) != 0);
        return class_4608.method_23625((int)u, (int)v);
    }

    public static enum Type {
        IN_HELD,
        IN_EQUIPMENT,
        IN_WARDROBE,
        IN_CONTAINER;

    }
}

