/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import java.util.IdentityHashMap;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.event.common.DataPackEvent;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FindableSkinManager {
    private static final FindableSkinManager INSTANCE = new FindableSkinManager();
    private static final class_793 GENERATION_MARKER = (class_793)class_156.method_654((Object)class_793.method_3430((String)"{\"gui_light\": \"front\"}"), blockModel -> {
        blockModel.field_4252 = "skin generation marker";
    });
    private final HashMap<String, Entry> allEntries = new HashMap();
    private final IdentityHashMap<class_1087, Entry> bakedModels = new IdentityHashMap();
    private SkinBakery bakery;

    private FindableSkinManager() {
        EventBus.register(DataPackEvent.Reloading.class, this::didReload);
    }

    public static FindableSkinManager getInstance() {
        return INSTANCE;
    }

    public void start() {
        this.bakery = SkinBakery.getInstance();
        for (Entry entry : this.allEntries.values()) {
            entry.preload(this.bakery);
        }
    }

    public void stop() {
        this.bakery = null;
    }

    public SkinDescriptor getSkin(class_1087 bakedModel) {
        Entry entry = this.bakedModels.get(bakedModel);
        if (entry != null && entry.canUse()) {
            return entry.descriptor;
        }
        return SkinDescriptor.EMPTY;
    }

    public void bakeSkinModel(class_793 unbakedModel, class_1087 bakedModel) {
        if (unbakedModel.method_3431() != GENERATION_MARKER) {
            return;
        }
        OpenResourceLocation model = OpenResourceLocation.parse(unbakedModel.field_4252);
        Entry entry = this.loadSkinProvider(model);
        if (entry == null) {
            return;
        }
        ModLog.debug("Registering resource pack skin: '{}' in '{}'", entry.identifier, model);
        this.bakedModels.put(bakedModel, entry);
        this.allEntries.put(entry.identifier, entry);
        if (this.bakery != null) {
            entry.preload(this.bakery);
        }
    }

    @Nullable
    public class_793 loadSkinModel(class_2960 location) {
        String path = location.method_12832();
        if (path.startsWith("skin/generated")) {
            return GENERATION_MARKER;
        }
        return null;
    }

    private Entry loadSkinProvider(IResourceLocation id) {
        try {
            IResourceManager resourceManager = EnvironmentManager.getResourceManager();
            IResourceLocation location = id.withPath("models/" + id.path() + ".json");
            IODataObject rootObject = JsonSerializer.readFromResource(resourceManager.readResource(location));
            if (rootObject == null) {
                return null;
            }
            IODataObject firstObject = rootObject.get("providers").get("layer0");
            return new Entry(firstObject.stringValue());
        }
        catch (Exception e) {
            ModLog.warn("Unable to bake model: '{}', {}", id, e.getMessage());
            return null;
        }
    }

    public void didReload(DataPackEvent.Reloading event) {
        if (event.type() == DataPackType.CLIENT_RESOURCES) {
            ModLog.debug("Reloading resource pack skins", new Object[0]);
            this.allEntries.clear();
            this.bakedModels.clear();
        }
    }

    public static class Entry {
        private final String identifier;
        private final boolean isLocalFile;
        private SkinDescriptor descriptor;

        public Entry(String identifier) {
            this.identifier = identifier;
            this.isLocalFile = DataDomain.isLocal(identifier);
            this.descriptor = new SkinDescriptor(identifier);
        }

        public void preload(SkinBakery bakery) {
            if (!this.canUse()) {
                return;
            }
            ModLog.debug("'{}' => start preload skin", this.identifier);
            this.descriptor = new SkinDescriptor(this.identifier);
            bakery.loadSkin(this.identifier, Tickets.PRELOAD, this::complete);
        }

        public void complete(BakedSkin bakedSkin, Exception exception) {
            if (exception != null) {
                return;
            }
            ModLog.debug("'{}' => did preload skin", this.identifier);
            this.descriptor = new SkinDescriptor(this.identifier, bakedSkin.type());
        }

        public boolean canUse() {
            return this.isLocalFile || ModConfig.Common.enableServerSkinsInResourcePack;
        }
    }
}

