/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderHelper;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;

@Environment(value=EnvType.CLIENT)
public class SkinRenderTesselator
extends SkinRenderContext {
    private final BakedSkin bakedSkin;
    private final BakedArmature bakedArmature;
    private final MannequinEntity mannequin;

    public SkinRenderTesselator(BakedSkin bakedSkin, BakedArmature bakedArmature, MannequinEntity mannequin) {
        super(null);
        this.bakedSkin = bakedSkin;
        this.mannequin = mannequin;
        this.bakedArmature = bakedArmature;
    }

    public static SkinRenderTesselator create(SkinDescriptor descriptor, Ticket ticket) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, ticket);
        if (bakedSkin != null) {
            return SkinRenderTesselator.create(bakedSkin);
        }
        return null;
    }

    public static SkinRenderTesselator create(BakedSkin bakedSkin) {
        MannequinEntity mannequin = PlaceholderManager.MANNEQUIN.get();
        BakedArmature bakedArmature = BakedArmature.defaultBy(bakedSkin.type());
        if (bakedArmature == null || mannequin == null || mannequin.method_37908() == null) {
            return null;
        }
        return new SkinRenderTesselator(bakedSkin, bakedArmature, mannequin);
    }

    public int draw() {
        this.bakedSkin.setupAnim((class_1297)this.mannequin, this.bakedArmature, this);
        SkinPaintScheme paintScheme = this.bakedSkin.resolve((class_1297)this.mannequin, this.colorScheme());
        if (this.isUseItemTransforms()) {
            BakedItemTransform itemTransform = this.bakedSkin.itemTransform();
            itemTransform.apply(this.poseStack, (class_1297)this.mannequin(), this.bakedSkin, this);
        }
        SkinRenderer.render((class_1297)this.mannequin, this.bakedArmature, this.bakedSkin, paintScheme, this);
        return SkinRenderHelper.getRenderCount(this.bakedSkin);
    }

    public MannequinEntity mannequin() {
        return this.mannequin;
    }

    public BakedSkin skin() {
        return this.bakedSkin;
    }
}

