/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.nio.ByteBuffer;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.init.ModLog;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL15;

@Environment(value=EnvType.CLIENT)
public class VertexIndexObject {
    private final int id;
    private final int vertexStride;
    private final int indexStride;
    private final IndexGenerator generator;
    private int size;
    private int capacity;
    private IndexType type = IndexType.BYTE;

    public VertexIndexObject(int vertexStride, int indexStride, IndexGenerator generator) {
        this.vertexStride = vertexStride;
        this.indexStride = indexStride;
        this.generator = generator;
        this.id = GL15.glGenBuffers();
    }

    public static void unbind() {
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public void bind() {
        GL15.glBindBuffer((int)34963, (int)this.id);
        this.uploadStorageIfNeeded(this.capacity);
    }

    public void ensureCapacity(int i) {
        if (this.capacity < i) {
            this.capacity = i;
        }
    }

    private void uploadStorageIfNeeded(int total) {
        if (total <= this.size) {
            return;
        }
        total = OpenMath.roundToward(total * 2, this.indexStride);
        ModLog.debug("growing index buffer {} => {}.", this.size, total);
        IndexType indexType = IndexType.least(total);
        int bufferSize = OpenMath.roundToward(total * indexType.bytes, 4);
        GL15.glBufferData((int)34963, (long)bufferSize, (int)35048);
        ByteBuffer buffer = GL15.glMapBuffer((int)34963, (int)35001);
        if (buffer == null) {
            throw new RuntimeException("Failed to map GL buffer");
        }
        this.type = indexType;
        IntConsumer builder = indexType.builder(buffer);
        for (int k = 0; k < total; k += this.indexStride) {
            this.generator.accept(builder, k * this.vertexStride / this.indexStride);
        }
        GL15.glUnmapBuffer((int)34963);
        this.size = total;
    }

    public int stride(int count) {
        return count / this.vertexStride * this.indexStride;
    }

    public int type() {
        return this.type.asGLType;
    }

    public static enum IndexType {
        BYTE(5121, 1),
        SHORT(5123, 2),
        INT(5125, 4);

        public final int asGLType;
        public final int bytes;

        private IndexType(int type, int bytes) {
            this.asGLType = type;
            this.bytes = bytes;
        }

        public static IndexType least(int i) {
            if ((i & 0xFFFF0000) != 0) {
                return INT;
            }
            if ((i & 0xFF00) != 0) {
                return SHORT;
            }
            return BYTE;
        }

        public IntConsumer builder(ByteBuffer buffer) {
            return switch (this.ordinal()) {
                case 0 -> i -> buffer.put((byte)i);
                case 1 -> i -> buffer.putShort((short)i);
                default -> buffer::putInt;
            };
        }
    }

    public static interface IndexGenerator {
        public void accept(IntConsumer var1, int var2);
    }
}

