/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRendererContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_897;

public abstract class EntityRenderPatch<T extends class_1297> {
    protected final int version;
    protected final SkinRenderContext renderingContext = new SkinRenderContext();
    protected final DefaultArmaturePluginContext pluginContext = new DefaultArmaturePluginContext();
    protected BakedArmatureTransformer transformer;

    public EntityRenderPatch(EntityRenderData renderData, EntityRendererContext context) {
        this.version = context.version();
        this.pluginContext.setRenderData(renderData);
        this.renderingContext.setRenderData(renderData);
    }

    protected static <T extends class_1297, P extends EntityRenderPatch<? super T>> void _activate(Class<?> clazz, T entity, float partialTicks, int packedLight, class_4587 poseStackIn, class_897<?> entityRenderer, Consumer<P> handler, Factory<? extends T> factory) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        EntityRenderPatch renderPatch = renderData.renderPatch();
        EntityRendererContext rendererContext = EntityRendererContext.of(entityRenderer);
        if (!clazz.isInstance(renderPatch) || !renderPatch.isValid(rendererContext)) {
            EntityRenderPatch<? extends T> renderPatch1 = factory.create(renderData, rendererContext);
            renderPatch = (EntityRenderPatch)Objects.unsafeCast(renderPatch1);
            renderData.setRenderPatch(renderPatch);
            if (renderPatch == null) {
                return;
            }
        }
        renderPatch.onInit(entity, partialTicks, packedLight, poseStackIn, entityRenderer);
        renderPatch.onActivate(entity);
        if (handler != null) {
            handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
        }
    }

    protected static <T extends class_1297, P extends EntityRenderPatch<? super T>> void _apply(Class<?> clazz, T entity, class_4587 poseStackIn, class_4597 bufferSourceIn, Consumer<P> handler) {
        EntityRenderPatch<? super class_1297> renderPatch;
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.renderPatch())) {
            if (handler != null) {
                handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
            }
            renderPatch.onApply(entity, poseStackIn, bufferSourceIn);
        }
    }

    protected static <T extends class_1297, P extends EntityRenderPatch<? super T>> void _deactivate(Class<?> clazz, T entity, Consumer<P> handler) {
        EntityRenderPatch<? super class_1297> renderPatch;
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.renderPatch())) {
            renderPatch.onDeactivate(entity);
            if (handler != null) {
                handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
            }
        }
    }

    protected void onInit(T entity, float partialTicks, int packedLight, class_4587 poseStackIn, class_897<?> entityRenderer) {
        this.pluginContext.setPartialTicks(partialTicks);
        this.pluginContext.setAnimationTicks(TickUtils.animationTicks());
        this.pluginContext.setLightmap(packedLight);
        this.pluginContext.setPoseStack(AbstractPoseStack.wrap(poseStackIn));
    }

    protected void onActivate(T entity) {
        if (this.transformer != null) {
            this.transformer.prepare((class_1297)entity, this.pluginContext);
        }
    }

    protected void onApply(T entity, class_4587 poseStackIn, class_4597 bufferSourceIn) {
        if (this.transformer != null) {
            this.transformer.activate((class_1297)entity, this.pluginContext);
        }
    }

    protected void onDeactivate(T entity) {
        if (this.transformer != null) {
            this.transformer.deactivate((class_1297)entity, this.pluginContext);
        }
    }

    public boolean isValid(EntityRendererContext context) {
        return this.version == context.version();
    }

    public BakedArmatureTransformer transformer() {
        return this.transformer;
    }

    public DefaultArmaturePluginContext pluginContext() {
        return this.pluginContext;
    }

    public SkinRenderContext renderingContext() {
        return this.renderingContext;
    }

    @FunctionalInterface
    public static interface Factory<T extends class_1297> {
        public EntityRenderPatch<T> create(EntityRenderData var1, EntityRendererContext var2);
    }
}

