/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;

public class GenericProperties<S> {
    private final ArrayList<GenericProperty<S, ?>> properties = new ArrayList();
    private final BiFunction<S, GenericValue<S, ?>, CustomPacket> factory;

    protected GenericProperties(BiFunction<S, GenericValue<S, ?>, CustomPacket> factory) {
        this.factory = factory;
    }

    public static <S> GenericProperties<S> of(Class<S> clazz, BiFunction<S, GenericValue<S, ?>, CustomPacket> factory) {
        return new GenericProperties<S>(factory);
    }

    public <T> Builder<S, T> create(IEntitySerializer<T> serializer) {
        return new Builder(this, serializer);
    }

    public GenericValue<S, ?> read(IFriendlyByteBuf buf) {
        int ordinal = buf.readVarInt();
        GenericProperty<S, ?> property = this.properties.get(ordinal);
        return this.decodePacket(property, buf);
    }

    protected <T> CustomPacket encodePacket(GenericProperty<S, T> property, T value, S source) {
        return this.factory.apply(source, new Holder<S, T>(property, value));
    }

    protected <T> GenericValue<S, T> decodePacket(GenericProperty<S, T> property, IFriendlyByteBuf buf) {
        Object value = property.serializer.read(buf);
        return new Holder<S, T>(property, value);
    }

    public static class Builder<S, T> {
        private final GenericProperties<S> owner;
        private final IEntitySerializer<T> serializer;
        private Function<S, T> getter;
        private BiConsumer<S, T> setter;

        private Builder(GenericProperties<S> owner, IEntitySerializer<T> serializer) {
            this.owner = owner;
            this.serializer = serializer;
        }

        public Builder<S, T> setter(BiConsumer<S, T> applier) {
            this.setter = applier;
            return this;
        }

        public Builder<S, T> getter(Function<S, T> supplier) {
            this.getter = supplier;
            return this;
        }

        public <P extends GenericProperty<S, T>> P build(Supplier<P> factory) {
            GenericProperty property = (GenericProperty)factory.get();
            property.owner = this.owner;
            property.serializer = this.serializer;
            property.getter = this.getter;
            property.setter = this.setter;
            property.ordinal = this.owner.properties.size();
            this.owner.properties.add(property);
            return (P)property;
        }
    }

    protected static class Holder<S, T>
    extends GenericValue<S, T> {
        private final GenericProperty<S, T> property;
        private final T value;

        protected Holder(GenericProperty<S, T> property, T value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public void apply(S source) {
            this.property.set(source, this.value);
        }

        @Override
        public void write(IFriendlyByteBuf buf) {
            buf.writeVarInt(this.property.ordinal);
            this.property.serializer.write(buf, this.value);
        }

        @Override
        public GenericProperty<S, T> property() {
            return this.property;
        }

        @Override
        public T value() {
            return this.value;
        }
    }
}

