/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get())) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public class_1269 useOnFirst(class_1799 itemStack, class_1838 context) {
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (level.method_8608() || player == null) {
            return class_1269.field_5812;
        }
        class_4208 linkedPos = (class_4208)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.method_8037());
        if (blockEntity != null && player.method_21823()) {
            blockEntity.setLinkedPos(null);
            SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.clear", new Object[0]));
            return class_1269.field_5812;
        }
        if (linkedPos != null) {
            if (Objects.equals(level.method_27983(), linkedPos.method_19442())) {
                int maxDistance = ModConfig.Common.maxLinkDistance;
                if (maxDistance > 0 && !context.method_8037().method_19771((class_2382)linkedPos.method_19446(), (double)maxDistance + 0.5)) {
                    SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.targetTooFar", new Object[0]));
                    return class_1269.field_5814;
                }
            } else if (!ModConfig.Common.enableLinkDimensional) {
                SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.targetWrongDimensions", new Object[0]));
                return class_1269.field_5814;
            }
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
            if (blockEntity != null) {
                blockEntity.setLinkedPos(linkedPos);
                SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.finish", new Object[0]));
                return class_1269.field_5812;
            }
            SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.fail", new Object[0]));
            return class_1269.field_5812;
        }
        if (blockEntity != null) {
            SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.linkedToSkinnable", new Object[0]));
            return class_1269.field_5814;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get(), class_4208.method_19443((class_5321)level.method_27983(), (class_2338)context.method_8037()));
        SystemMessageProvider.sendSystemMessage(player, (class_2561)TranslatableProvider.translatable(class_2561.class, "inventory.armourers_workshop.linking-tool.start", new Object[0]));
        return class_1269.field_5812;
    }

    private SkinnableBlockEntity getTitleEntity(class_1937 level, class_2338 blockPos) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

