/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenVector4f {
    public static final OpenVector4f ONE = new OpenVector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final OpenVector4f ZERO = new OpenVector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public OpenVector4f() {
    }

    public OpenVector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public OpenVector4f(IVector3f pos) {
        this(pos.x(), pos.y(), pos.z(), 1.0f);
    }

    public OpenVector4f(OpenVector4f pos) {
        this(pos.x, pos.y, pos.z, pos.w);
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void add(float tx, float ty, float tz, float tw) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
        this.w += tw;
    }

    public void add(OpenVector4f pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
        this.w += pos.w;
    }

    public void subtract(float tx, float ty, float tz, float tw) {
        this.x -= tx;
        this.y -= ty;
        this.z -= tz;
        this.w += tw;
    }

    public void subtract(OpenVector4f pos) {
        this.x -= pos.x;
        this.y -= pos.y;
        this.z -= pos.z;
        this.w -= pos.w;
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
    }

    public void scale(float sx, float sy, float sz, float sw) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
        this.w *= sw;
    }

    public void scale(OpenVector4f pos) {
        this.x *= pos.x;
        this.y *= pos.y;
        this.z *= pos.z;
        this.w *= pos.w;
    }

    public void transform(IMatrix4f matrix) {
        float[] floats = new float[]{this.x, this.y, this.z, this.w};
        matrix.multiply(floats);
        this.set(floats[0], floats[1], floats[2], floats[3]);
    }

    public void transform(OpenQuaternionf q) {
        OpenQuaternionf quaternion = new OpenQuaternionf(q);
        quaternion.mul(new OpenQuaternionf(this.x, this.y, this.z, 0.0f));
        OpenQuaternionf quaternion1 = new OpenQuaternionf(q);
        quaternion1.conjugate();
        quaternion.mul(quaternion1);
        this.set(quaternion.x(), quaternion.y(), quaternion.z(), this.w);
    }

    public float dot(OpenVector4f pos) {
        return this.x * pos.x + this.y * pos.y + this.z * pos.z + this.w * pos.w;
    }

    public float length() {
        return OpenMath.sqrt(OpenMath.fma(this.x, this.x, OpenMath.fma(this.y, this.y, OpenMath.fma(this.z, this.z, this.w * this.w))));
    }

    public void normalize() {
        float scalar = OpenMath.invsqrt(OpenMath.fma(this.x, this.x, OpenMath.fma(this.y, this.y, OpenMath.fma(this.z, this.z, this.w * this.w))));
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
    }

    public OpenVector4f scaling(float scalar) {
        OpenVector4f ret = this.copy();
        ret.scale(scalar);
        return ret;
    }

    public OpenVector4f scaling(float sx, float sy, float sz, float sw) {
        OpenVector4f ret = this.copy();
        ret.scale(sx, sy, sz, sw);
        return ret;
    }

    public OpenVector4f scaling(OpenVector4f pos) {
        OpenVector4f ret = this.copy();
        ret.scale(pos);
        return ret;
    }

    public OpenVector4f adding(float tx, float ty, float tz, float tw) {
        OpenVector4f ret = this.copy();
        ret.add(tx, ty, tz, tw);
        return ret;
    }

    public OpenVector4f adding(OpenVector4f pos) {
        OpenVector4f ret = this.copy();
        ret.add(pos);
        return ret;
    }

    public OpenVector4f subtracting(float tx, float ty, float tz, float tw) {
        OpenVector4f ret = this.copy();
        ret.subtract(tx, ty, tz, tw);
        return ret;
    }

    public OpenVector4f subtracting(OpenVector4f pos) {
        OpenVector4f ret = this.copy();
        ret.subtract(pos);
        return ret;
    }

    public OpenVector4f transforming(IMatrix4f mat) {
        OpenVector4f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public OpenVector4f transforming(OpenQuaternionf value) {
        OpenVector4f ret = this.copy();
        ret.transform(value);
        return ret;
    }

    public OpenVector4f normalizing() {
        OpenVector4f ret = this.copy();
        ret.normalize();
        return ret;
    }

    public OpenVector4f copy() {
        return new OpenVector4f(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector4f)) {
            return false;
        }
        OpenVector4f that = (OpenVector4f)o;
        return Float.compare(this.x, that.x) == 0 && Float.compare(this.y, that.y) == 0 && Float.compare(this.z, that.z) == 0 && Float.compare(this.w, that.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    public String toString() {
        return OpenMath.format("(%f %f %f %f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }
}

