/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class UpdateAnimationPacket
extends CustomPacket {
    private final Mode mode;
    private final class_2487 value;

    public UpdateAnimationPacket(Mode mode, class_2487 value) {
        this.mode = mode;
        this.value = value;
    }

    public UpdateAnimationPacket(IFriendlyByteBuf buffer) {
        this.mode = buffer.readEnum(Mode.class);
        this.value = buffer.readNbt();
    }

    public static UpdateAnimationPacket play(Selector selector, String name, class_2487 properties) {
        class_2487 tag = selector.save();
        tag.method_10582("name", name);
        tag.method_10566("properties", (class_2520)properties);
        return new UpdateAnimationPacket(Mode.PLAY, tag);
    }

    public static UpdateAnimationPacket stop(Selector selector, String name) {
        class_2487 tag = selector.save();
        tag.method_10582("name", name);
        return new UpdateAnimationPacket(Mode.STOP, tag);
    }

    public static UpdateAnimationPacket rewrite(Selector selector, String from, String to) {
        class_2487 tag = selector.save();
        tag.method_10582("from", from);
        tag.method_10582("to", to);
        return new UpdateAnimationPacket(Mode.MAPPING, tag);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.mode);
        buffer.writeNbt(this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, class_1657 player) {
        switch (this.mode.ordinal()) {
            case 0: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = OptionalAPI.getOptionalString(this.value, "name").orElse("");
                class_2487 properties = OptionalAPI.getOptionalCompound(this.value, "properties").orElseGet(class_2487::new);
                ModLog.debug("play animation {}", this.value);
                animationManager.play(name, TickUtils.animationTicks(), properties);
                break;
            }
            case 1: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = OptionalAPI.getOptionalString(this.value, "name").orElse("");
                ModLog.debug("stop animation {}", this.value);
                animationManager.stop(name);
                break;
            }
            case 2: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String from = OptionalAPI.getOptionalString(this.value, "from").orElse("");
                String to = OptionalAPI.getOptionalString(this.value, "to").orElse("");
                ModLog.debug("rewrite animation {} to {}", from, to);
                animationManager.map(from, to);
                break;
            }
        }
    }

    private AnimationManager getTargetRenderData(class_1657 player) {
        if (this.value.method_10545("entity")) {
            Integer entityId = OptionalAPI.getOptionalInt(this.value, "entity").orElse(0);
            return AnimationManager.of(player.method_37908().method_8469(entityId.intValue()));
        }
        if (this.value.method_10545("block")) {
            class_2338 blockPos = class_2338.method_10092((long)OptionalAPI.getOptionalLong(this.value, "block").orElse(0L));
            return AnimationManager.of(player.method_37908().method_8321(blockPos));
        }
        return null;
    }

    public static enum Mode {
        PLAY,
        STOP,
        MAPPING,
        MODERATOR;

    }

    public static class Selector {
        private final int id;
        private final class_2338 pos;

        public Selector(class_1297 entity) {
            this.id = entity.method_5628();
            this.pos = null;
        }

        public Selector(class_2338 blockPos) {
            this.id = -1;
            this.pos = blockPos;
        }

        public class_2487 save() {
            class_2487 tag = new class_2487();
            if (this.pos != null) {
                tag.method_10544("block", this.pos.method_10063());
            } else {
                tag.method_10569("entity", this.id);
            }
            return tag;
        }
    }
}

