/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.List;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraft.class_1799;

public class SkinType
implements ISkinType {
    protected final String name;
    protected final int id;
    protected OpenResourceLocation registryName;
    protected List<? extends SkinPartType> parts;

    public SkinType(String name, int id, List<? extends SkinPartType> parts) {
        this.parts = parts;
        this.name = name;
        this.id = id;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.registryName.toString();
    }

    @Override
    public OpenResourceLocation registryName() {
        return this.registryName;
    }

    public void setRegistryName(OpenResourceLocation registryName) {
        this.registryName = registryName;
    }

    public String toString() {
        return Objects.toString(this, "id", this.id, "name", this.registryName);
    }

    public List<? extends SkinPartType> parts() {
        return this.parts;
    }

    @Override
    public boolean isArmour() {
        return this instanceof Armor;
    }

    @Override
    public boolean isTool() {
        return this instanceof Tool;
    }

    public static class Armor
    extends SkinType {
        protected OpenEquipmentSlot slotType;

        public Armor(String name, int id, OpenEquipmentSlot slotType, List<? extends SkinPartType> parts) {
            super(name, id, parts);
            this.slotType = slotType;
        }

        public OpenEquipmentSlot slotType() {
            return this.slotType;
        }
    }

    public static class Tool
    extends SkinType {
        protected Predicate<class_1799> predicate;

        public Tool(String name, int id, List<? extends SkinPartType> parts, Predicate<class_1799> predicate) {
            super(name, id, parts);
            this.predicate = predicate;
        }

        public boolean contains(class_1799 itemStack) {
            return this.predicate.test(itemStack);
        }
    }
}

