/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.skin.part.ISkinPart;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV0;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.utils.Objects;
import org.jetbrains.annotations.Nullable;

public class SkinPart
implements ISkinPart {
    protected final String name;
    protected final SkinPartType type;
    protected final ITransform transform;
    protected final SkinGeometrySet<?> geometries;
    protected final List<SkinPart> children = new ArrayList<SkinPart>();
    protected final List<SkinMarker> markers = new ArrayList<SkinMarker>();
    protected final Object blobs;
    protected SkinProperties properties = SkinProperties.EMPTY;
    private HashMap<OpenVector3i, OpenRectangle3f> blockBounds;

    protected SkinPart(String name, SkinPartType type, SkinProperties properties, ITransform transform, SkinGeometrySet<?> geometries, List<SkinMarker> markers, Object blobs) {
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.transform = transform;
        this.geometries = geometries;
        this.markers.addAll(markers);
        this.blobs = blobs;
    }

    public void addPart(SkinPart part) {
        this.children.add(part);
    }

    public void removePart(SkinPart part) {
        this.children.remove(part);
    }

    public void setProperties(SkinProperties properties) {
        this.properties = properties;
    }

    public SkinProperties properties() {
        return this.properties;
    }

    public int modelCount() {
        return 0;
    }

    public Map<OpenVector3i, OpenRectangle3f> blockBounds() {
        if (this.blockBounds != null) {
            return this.blockBounds;
        }
        HashMap<OpenVector3i, OpenRectangle3f> blockGrid = new HashMap<OpenVector3i, OpenRectangle3f>();
        this.blockBounds = new HashMap();
        this.geometries.forEach(geometry -> {
            OpenRectangle3f boundingBox = geometry.shape().bounds();
            float x = boundingBox.x();
            float y = boundingBox.y();
            float z = boundingBox.z();
            int tx = OpenMath.floori((x + 8.0f) / 16.0f);
            int ty = OpenMath.floori((y + 8.0f) / 16.0f);
            int tz = OpenMath.floori((z + 8.0f) / 16.0f);
            OpenRectangle3f rec = new OpenRectangle3f(-(x - (float)(tx * 16)) - 1.0f, -(y - (float)(ty * 16)) - 1.0f, z - (float)(tz * 16), 1.0f, 1.0f, 1.0f);
            blockGrid.computeIfAbsent(new OpenVector3i(-tx, -ty, tz), k -> rec).union(rec);
        });
        blockGrid.forEach((key, value) -> this.blockBounds.put((OpenVector3i)key, (OpenRectangle3f)value));
        return this.blockBounds;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public SkinPartType type() {
        return this.type;
    }

    @Override
    public ITransform transform() {
        return this.transform;
    }

    public SkinGeometrySet<?> geometries() {
        return this.geometries;
    }

    public List<SkinPart> children() {
        return this.children;
    }

    public List<SkinMarker> markers() {
        return this.markers;
    }

    public Object blobs() {
        return this.blobs;
    }

    public String toString() {
        return Objects.toString(this, "name", this.name, "type", this.type, "transform", this.transform, "markers", this.markers, "cubes", this.geometries);
    }

    public static class Builder {
        private final SkinPartType type;
        private String name;
        private SkinGeometrySet<?> geometries = SkinGeometrySetV0.EMPTY;
        private ITransform transform = OpenTransform3f.IDENTITY;
        private ArrayList<SkinMarker> markers = new ArrayList();
        private ArrayList<SkinPart> children = new ArrayList();
        private SkinProperties properties = SkinProperties.EMPTY;
        private Object blobs;

        public Builder(SkinPartType type) {
            this.type = type;
        }

        public Builder copyFrom(SkinPart part) {
            this.name(part.name());
            this.transform(part.transform());
            this.geometries((SkinGeometrySet<?>)part.geometries());
            this.markers((List<SkinMarker>)part.markers());
            this.children((List<SkinPart>)part.children());
            this.properties(part.properties());
            this.blobs(part.blobs());
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder transform(ITransform transform) {
            if (transform != null) {
                this.transform = transform;
            }
            return this;
        }

        public Builder geometries(SkinGeometrySet<?> geometries) {
            this.geometries = geometries;
            return this;
        }

        public Builder markers(List<SkinMarker> markers) {
            if (markers != null) {
                this.markers = new ArrayList<SkinMarker>(markers);
            }
            return this;
        }

        public Builder children(List<SkinPart> children) {
            if (children != null) {
                this.children = new ArrayList<SkinPart>(children);
            }
            return this;
        }

        public Builder properties(SkinProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public SkinPart build() {
            SkinPart skinPart = new SkinPart(this.name, this.type, this.properties, this.transform, this.geometries, this.markers, this.blobs);
            this.children.forEach(skinPart::addPart);
            return skinPart;
        }
    }
}

