/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanOverride;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public final class SkinUtils {
    public static Collection<String> getItemOverrides(SkinPartType partType) {
        ICanOverride override = Objects.safeCast(partType, ICanOverride.class);
        if (override != null) {
            return override.itemOverrides();
        }
        return Collections.emptyList();
    }

    public static boolean shouldKeepWardrobe(class_1657 entity) {
        if (entity.method_7325()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return entity.method_37908().method_8450().method_8355(class_1928.field_19389);
    }

    public static void dropAllIfNeeded(class_1657 player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((class_1297)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((class_1657)player).method_5775(arg_0));
            oldWardrobe.broadcast();
        }
    }

    public static <T extends class_1297> Consumer<T> appendSkinIntoEntity(Consumer<T> consumer, class_3218 serverLevel, class_1799 itemStack, @Nullable class_1657 player) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(entity -> {
            if (!(entity instanceof class_1690) && !(entity instanceof class_1688)) {
                return;
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            if (wardrobe != null) {
                wardrobe.setItem(SkinSlotType.ANY, 0, descriptor.asItemStack());
                wardrobe.broadcast();
            }
        });
    }

    public static <T extends class_1297> Consumer<class_1799> appendSkinIntoItemStack(Consumer<class_1799> consumer, T entity) {
        if (!(entity instanceof class_1690) && !(entity instanceof class_1688)) {
            return consumer;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe == null) {
            return consumer;
        }
        class_1799 itemStack1 = wardrobe.getItem(SkinSlotType.ANY, 0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack1);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(itemStack -> ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor));
    }

    public static void copySkinWardrobe(class_1297 from, class_1297 to) {
        SkinWardrobe oldWardrobe = SkinWardrobe.of(from);
        SkinWardrobe newWardrobe = SkinWardrobe.of(to);
        if (newWardrobe != null && oldWardrobe != null) {
            TagSerializer serializer = new TagSerializer(new class_2487(), to);
            oldWardrobe.serialize(serializer);
            newWardrobe.deserialize(serializer);
            if (!to.method_37908().method_8608()) {
                newWardrobe.broadcast();
            }
        }
    }

    public static void copySkinFromOwner(class_1297 entity) {
        class_1676 projectile = Objects.safeCast(entity, class_1676.class);
        if (projectile == null) {
            return;
        }
        class_1297 owner = projectile.method_24921();
        if (entity instanceof class_1685) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof class_1665) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof class_1536 && owner instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            class_1799 itemStack = livingEntity.method_6047();
            if (!itemStack.method_31574(class_1802.field_8378)) {
                itemStack = livingEntity.method_6079();
            }
            SkinUtils.copySkin(entity, itemStack, SkinSlotType.ANY, 0);
            return;
        }
    }

    public static void copySkin(class_1297 src, class_1297 dest, SkinSlotType fromSlotType, int fromIndex, SkinSlotType toSlotType, int toIndex) {
        class_1799 itemStack = SkinUtils.getSkin(src, fromSlotType, fromIndex);
        if (itemStack.method_7960()) {
            return;
        }
        SkinUtils.copySkin(dest, itemStack, toSlotType, toIndex);
    }

    public static void copySkin(class_1297 dest, class_1799 itemStack, SkinSlotType toSlotType, int toIndex) {
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(toSlotType, toIndex, itemStack.method_7972());
            wardrobe.broadcast();
        }
    }

    public static class_1799 getSkin(class_1297 entity, SkinSlotType slotType, int index) {
        class_1799 itemStack = class_1799.field_8037;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            itemStack = SkinUtils.getUsingItem(livingEntity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.skinType(), descriptor.type())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            class_1799 itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.skinType(), descriptor.type())) {
                return itemStack1;
            }
        }
        return class_1799.field_8037;
    }

    private static class_1799 getUsingItem(class_1309 entity) {
        class_1799 itemStack = entity.method_6030();
        if (!itemStack.method_7960()) {
            return itemStack;
        }
        itemStack = entity.method_6047();
        if (itemStack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)itemStack)) {
            return itemStack;
        }
        return class_1799.field_8037;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static class_265 apply(class_265 shape, OpenMatrix4f matrix) {
        float minX = (float)shape.method_1091(class_2350.class_2351.field_11048);
        float minY = (float)shape.method_1091(class_2350.class_2351.field_11052);
        float minZ = (float)shape.method_1091(class_2350.class_2351.field_11051);
        float maxX = (float)shape.method_1105(class_2350.class_2351.field_11048);
        float maxY = (float)shape.method_1105(class_2350.class_2351.field_11052);
        float maxZ = (float)shape.method_1105(class_2350.class_2351.field_11051);
        OpenVector4f[] points = new OpenVector4f[]{new OpenVector4f(minX, minY, minZ, 1.0f), new OpenVector4f(maxX, minY, minZ, 1.0f), new OpenVector4f(maxX, maxY, minZ, 1.0f), new OpenVector4f(minX, maxY, minZ, 1.0f), new OpenVector4f(minX, minY, maxZ, 1.0f), new OpenVector4f(maxX, minY, maxZ, 1.0f), new OpenVector4f(maxX, maxY, maxZ, 1.0f), new OpenVector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (OpenVector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return class_259.method_1081((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static float[][][] reorder(float[][][] values, int ... indexes) {
        float[][][] newValues = new float[values.length][][];
        for (int i = 0; i < values.length; ++i) {
            float[][] faces = values[i];
            float[][] newFaces = new float[faces.length][];
            for (int j = 0; j < faces.length; ++j) {
                if (j < indexes.length) {
                    newFaces[indexes[j]] = faces[j];
                    continue;
                }
                newFaces[j] = faces[j];
            }
            newValues[i] = newFaces;
        }
        return newValues;
    }
}

