/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.registry.IItemBuilder;
import moe.plushie.armourers_workshop.builder.client.render.SkinCubeItemRenderer;
import moe.plushie.armourers_workshop.builder.item.BlendingToolItem;
import moe.plushie.armourers_workshop.builder.item.BlockMarkerItem;
import moe.plushie.armourers_workshop.builder.item.BurnToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorPickerItem;
import moe.plushie.armourers_workshop.builder.item.DodgeToolItem;
import moe.plushie.armourers_workshop.builder.item.HueToolItem;
import moe.plushie.armourers_workshop.builder.item.PaintRollerItem;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.ShadeNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.item.SoapItem;
import moe.plushie.armourers_workshop.core.client.render.MannequinItemRenderer;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.item.ArmourersHammerItem;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.item.GiftSackItem;
import moe.plushie.armourers_workshop.core.item.LinkingToolItem;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.item.MannequinToolItem;
import moe.plushie.armourers_workshop.core.item.SkinItem;
import moe.plushie.armourers_workshop.core.item.SkinUnlockItem;
import moe.plushie.armourers_workshop.core.item.WandOfStyleItem;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.ModItemGroups;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;

public class ModItems {
    private static final ItemBuilder MAIN = new ItemBuilder(ModItemGroups.MAIN_GROUP);
    private static final ItemBuilder BUILDING = new ItemBuilder(ModItemGroups.BUILDING_GROUP);
    private static final ItemBuilder NONE = new ItemBuilder(null);
    public static final IRegistryHolder<class_1792> SKIN = (IRegistryHolder)NONE.skin(ModBlocks.SKINNABLE).bind(() -> SkinItemRenderer::getInstance).build("skin");
    public static final IRegistryHolder<class_1792> MANNEQUIN = (IRegistryHolder)MAIN.normal(MannequinItem::new).rarity(class_1814.field_8903).bind(() -> MannequinItemRenderer::getInstance).build("mannequin");
    public static final IRegistryHolder<class_1792> SKIN_LIBRARY = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY).build("skin-library");
    public static final IRegistryHolder<class_1792> SKIN_LIBRARY_CREATIVE = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY_CREATIVE).rarity(class_1814.field_8904).build("skin-library-creative");
    public static final IRegistryHolder<class_1792> SKIN_LIBRARY_GLOBAL = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY_GLOBAL).build("skin-library-global");
    public static final IRegistryHolder<class_1792> SKINNING_TABLE = (IRegistryHolder)MAIN.block(ModBlocks.SKINNING_TABLE).build("skinning-table");
    public static final IRegistryHolder<class_1792> DYE_TABLE = (IRegistryHolder)MAIN.block(ModBlocks.DYE_TABLE).build("dye-table");
    public static final IRegistryHolder<class_1792> OUTFIT_MAKER = (IRegistryHolder)MAIN.block(ModBlocks.OUTFIT_MAKER).build("outfit-maker");
    public static final IRegistryHolder<class_1792> HOLOGRAM_PROJECTOR = (IRegistryHolder)MAIN.block(ModBlocks.HOLOGRAM_PROJECTOR).build("hologram-projector");
    public static final IRegistryHolder<class_1792> BOTTLE = (IRegistryHolder)MAIN.normal(BottleItem::new).stacksTo(64).build("dye-bottle");
    public static final IRegistryHolder<class_1792> MANNEQUIN_TOOL = (IRegistryHolder)MAIN.normal(MannequinToolItem::new).build("mannequin-tool");
    public static final IRegistryHolder<class_1792> ARMOURERS_HAMMER = (IRegistryHolder)MAIN.normal(ArmourersHammerItem::new).build("armourers-hammer");
    public static final IRegistryHolder<class_1792> WAND_OF_STYLE = (IRegistryHolder)MAIN.normal(WandOfStyleItem::new).build("wand-of-style");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_HEAD = (IRegistryHolder)MAIN.unlock(SkinSlotType.HEAD).build("skin-unlock-head");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_CHEST = (IRegistryHolder)MAIN.unlock(SkinSlotType.CHEST).build("skin-unlock-chest");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_FEET = (IRegistryHolder)MAIN.unlock(SkinSlotType.FEET).build("skin-unlock-feet");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_LEGS = (IRegistryHolder)MAIN.unlock(SkinSlotType.LEGS).build("skin-unlock-legs");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_WINGS = (IRegistryHolder)MAIN.unlock(SkinSlotType.WINGS).build("skin-unlock-wings");
    public static final IRegistryHolder<class_1792> SKIN_UNLOCK_OUTFIT = (IRegistryHolder)MAIN.unlock(SkinSlotType.OUTFIT).build("skin-unlock-outfit");
    public static final IRegistryHolder<class_1792> LINKING_TOOL = (IRegistryHolder)MAIN.normal(LinkingToolItem::new).build("linking-tool");
    public static final IRegistryHolder<class_1792> SKIN_TEMPLATE = (IRegistryHolder)MAIN.normal(FlavouredItem::new).stacksTo(64).build("skin-template");
    public static final IRegistryHolder<class_1792> SOAP = (IRegistryHolder)MAIN.normal(SoapItem::new).stacksTo(64).build("soap");
    public static final IRegistryHolder<class_1792> GIFT_SACK = (IRegistryHolder)MAIN.normal(GiftSackItem::new).stacksTo(64).build("gift-sack");
    public static final IRegistryHolder<class_1792> ARMOURER = (IRegistryHolder)BUILDING.block(ModBlocks.ARMOURER).rarity(class_1814.field_8904).build("armourer");
    public static final IRegistryHolder<class_1792> COLOR_MIXER = (IRegistryHolder)BUILDING.block(ModBlocks.COLOR_MIXER).build("colour-mixer");
    public static final IRegistryHolder<class_1792> ADVANCED_SKIN_BUILDER = (IRegistryHolder)BUILDING.block(ModBlocks.ADVANCED_SKIN_BUILDER).build("advanced-skin-builder");
    public static final IRegistryHolder<class_1792> SKIN_CUBE = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE).build("skin-cube");
    public static final IRegistryHolder<class_1792> SKIN_CUBE_GLOWING = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLOWING).build("skin-cube-glowing");
    public static final IRegistryHolder<class_1792> SKIN_CUBE_GLASS = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS).build("skin-cube-glass");
    public static final IRegistryHolder<class_1792> SKIN_CUBE_GLASS_GLOWING = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS_GLOWING).build("skin-cube-glass-glowing");
    public static final IRegistryHolder<class_1792> PAINT_BRUSH = (IRegistryHolder)BUILDING.normal(PaintbrushItem::new).build("paintbrush");
    public static final IRegistryHolder<class_1792> PAINT_ROLLER = (IRegistryHolder)BUILDING.normal(PaintRollerItem::new).build("paint-roller");
    public static final IRegistryHolder<class_1792> BURN_TOOL = (IRegistryHolder)BUILDING.normal(BurnToolItem::new).build("burn-tool");
    public static final IRegistryHolder<class_1792> DODGE_TOOL = (IRegistryHolder)BUILDING.normal(DodgeToolItem::new).build("dodge-tool");
    public static final IRegistryHolder<class_1792> SHADE_NOISE_TOOL = (IRegistryHolder)BUILDING.normal(ShadeNoiseToolItem::new).build("shade-noise-tool");
    public static final IRegistryHolder<class_1792> COLOR_NOISE_TOOL = (IRegistryHolder)BUILDING.normal(ColorNoiseToolItem::new).build("colour-noise-tool");
    public static final IRegistryHolder<class_1792> BLENDING_TOOL = (IRegistryHolder)BUILDING.normal(BlendingToolItem::new).build("blending-tool");
    public static final IRegistryHolder<class_1792> HUE_TOOL = (IRegistryHolder)BUILDING.normal(HueToolItem::new).build("hue-tool");
    public static final IRegistryHolder<class_1792> COLOR_PICKER = (IRegistryHolder)BUILDING.normal(ColorPickerItem::new).build("colour-picker");
    public static final IRegistryHolder<class_1792> BLOCK_MARKER = (IRegistryHolder)BUILDING.normal(BlockMarkerItem::new).build("block-marker");

    public static void init() {
    }

    private static class ItemBuilder {
        IRegistryHolder<IItemGroup> group;

        ItemBuilder(IRegistryHolder<IItemGroup> group) {
            this.group = group;
        }

        IItemBuilder<class_1792> normal(Function<class_1792.class_1793, class_1792> factory) {
            return this._create(factory).stacksTo(1).group(this.group);
        }

        IItemBuilder<class_1792> block(IRegistryHolder<class_2248> block) {
            return this._create(class_1747::new, block).stacksTo(64).rarity(class_1814.field_8903);
        }

        IItemBuilder<class_1792> cube(IRegistryHolder<class_2248> block) {
            return this._create(SkinCubeItem::new, block).stacksTo(64).bind(() -> SkinCubeItemRenderer::getInstance);
        }

        IItemBuilder<class_1792> skin(IRegistryHolder<class_2248> block) {
            return this._create(SkinItem::new, block).stacksTo(1);
        }

        IItemBuilder<class_1792> unlock(SkinSlotType slotType) {
            return this._create(SkinUnlockItem::new, () -> slotType).stacksTo(16).rarity(class_1814.field_8907);
        }

        private IItemBuilder<class_1792> _create(Function<class_1792.class_1793, class_1792> factory) {
            return (IItemBuilder)Objects.unsafeCast(BuilderManager.getInstance().createItemBuilder(factory));
        }

        private <T> IItemBuilder<class_1792> _create(BiFunction<T, class_1792.class_1793, class_1792> factory, Supplier<T> supplier) {
            return this._create(properties -> (class_1792)factory.apply(supplier.get(), (class_1792.class_1793)properties)).group(this.group);
        }
    }
}

