/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Minecraft.ItemModelProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModel;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModels;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinLuminanceManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
public class ClientDynamicLightHandler {
    private static class_1297 TICKING_ENTITY;

    public static void init() {
        ModConfig.Client.enableDynamicLightHandler = true;
    }

    public static void startTick(class_1297 entity) {
        TICKING_ENTITY = entity;
    }

    public static void endTick(class_1297 entity) {
        TICKING_ENTITY = null;
    }

    public static void apply(class_1799 itemStack, boolean submergedInWater, CallbackInfoReturnable<Integer> cir) {
        if (!ModConfig.enableDynamicLightHandler()) {
            return;
        }
        EmbeddedItemModel itemModel = ClientDynamicLightHandler.getItemModel(itemStack);
        if (itemModel == null) {
            return;
        }
        SkinDescriptor descriptor = itemModel.sourceSkin();
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin != null) {
            cir.setReturnValue((Object)bakedSkin.renderInfo().luminance());
        }
    }

    public static <T extends class_1297, A> A apply(A handler, T entity, Function<SkinLuminanceManager<? super T>, A> builder) {
        SkinLuminanceManager manger;
        if (!ModConfig.enableDynamicLightHandler()) {
            return handler;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && (manger = renderData.luminanceManager()).isEnabled()) {
            return DataContainer.of(manger, builder);
        }
        return handler;
    }

    public static <T extends class_2586, A> A apply(A handler, T entity, Function<SkinLuminanceManager<? super T>, A> builder) {
        SkinLuminanceManager manager;
        if (!ModConfig.enableDynamicLightHandler()) {
            return handler;
        }
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData != null && (manager = renderData.luminanceManager()).isEnabled()) {
            return DataContainer.of(manager, builder);
        }
        return handler;
    }

    private static EmbeddedItemModel getItemModel(class_1799 itemStack) {
        class_1297 class_12972 = TICKING_ENTITY;
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            return ClientDynamicLightHandler.getItemModel(itemStack, entity.method_37908(), entity);
        }
        return ClientDynamicLightHandler.getItemModel(itemStack, null, null);
    }

    private static EmbeddedItemModel getItemModel(class_1799 itemStack, @Nullable class_1937 level, @Nullable class_1309 entity) {
        class_1087 model = ItemModelProvider.getItemModel(class_310.method_1551(), itemStack, level, entity, 0);
        EmbeddedItemModels itemModels = EmbeddedItemModels.of(itemStack);
        return itemModels.get(model);
    }
}

