/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.command.ColorParser;
import net.minecraft.class_2561;

public class ColorSchemeParser {
    public static final DynamicCommandExceptionType ERROR_INVALID_DYE_FORMAT = new DynamicCommandExceptionType(obj -> TranslatableProvider.translatable(class_2561.class, "commands.armourers.invalidDyeFormat", obj));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private static final Map<String, SkinPaintType> DYE_TYPES = Collections.immutableMap(it -> {
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.registryName().path();
            it.put((Object)name.replaceAll("_", ""), (Object)paintType);
        }
    });
    private final StringReader reader;
    private final ColorParser colorParser;
    private final Map<SkinPaintType, SkinPaintColor> properties = new HashMap<SkinPaintType, SkinPaintColor>();
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    public ColorSchemeParser(StringReader stringReader) {
        this.reader = stringReader;
        this.colorParser = new ColorParser(stringReader);
    }

    public ColorSchemeParser parse() throws CommandSyntaxException {
        this.suggestions = this::suggestOpenProperties;
        if (this.reader.canRead() && this.reader.peek() == '<') {
            this.reader.skip();
            this.suggestions = this::suggestPropertyNameOrEnd;
            this.reader.skipWhitespace();
            while (this.reader.canRead() && this.reader.peek() != '>') {
                this.reader.skipWhitespace();
                int i = this.reader.getCursor();
                String string = this.reader.readString();
                SkinPaintType property = DYE_TYPES.get(string);
                if (property == null) {
                    this.reader.setCursor(i);
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                if (this.properties.containsKey(string)) {
                    this.reader.setCursor(i);
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                this.reader.skipWhitespace();
                this.suggestions = this::suggestEquals;
                if (!this.reader.canRead() || this.reader.peek() != '=') {
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                this.reader.skip();
                this.reader.skipWhitespace();
                this.suggestions = this.colorParser::fillSuggestions;
                this.properties.put(property, this.colorParser.parse().paintColor());
                this.suggestions = this::suggestNextPropertyOrEnd;
                if (!this.reader.canRead()) break;
                if (this.reader.peek() == ' ') {
                    this.reader.skip();
                    this.suggestions = this::suggestPropertyName;
                    continue;
                }
                if (this.reader.peek() != '>') continue;
                break;
            }
            if (!this.reader.canRead()) {
                throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)this.reader.getString());
            }
            this.reader.skip();
            this.suggestions = SUGGEST_NOTHING;
        }
        return this;
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestions.apply(builder.createOffset(this.reader.getCursor()));
    }

    public Map<SkinPaintType, SkinPaintColor> properties() {
        return this.properties;
    }

    private CompletableFuture<Suggestions> suggestOpenProperties(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('<'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('>'));
        }
        if (suggestionsBuilder.getRemaining().isEmpty() && this.properties.size() < DYE_TYPES.size()) {
            suggestionsBuilder.suggest(String.valueOf(' '));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('>'));
        }
        return this.suggestPropertyName(builder);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, SkinPaintType> entry : DYE_TYPES.entrySet()) {
            String name = entry.getKey();
            if (this.properties.containsKey(entry.getValue()) || !name.startsWith(string)) continue;
            builder.suggest(name + "=");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }
}

