/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.network.CustomReplyPacket;
import moe.plushie.armourers_workshop.core.utils.PacketSplitter;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.fabric.NetworkManagerImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3222;

public class NetworkManager {
    private static Dispatcher dispatcher;
    private static Distributors distributors;

    public static void init(String name, String version) {
        dispatcher = NetworkManager.createDispatcher(ModConstants.key(name), version);
        distributors = NetworkManager.createDistributors();
        dispatcher.register();
    }

    public static void sendToTrackingBlock(CustomPacket message, class_2586 blockEntity) {
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return;
        }
        class_2818 chunk = level.method_8500(blockEntity.method_11016());
        dispatcher.split(message, distributors.trackingChunk(() -> chunk));
    }

    public static void sendToTracking(CustomPacket message, class_1297 entity) {
        dispatcher.split(message, distributors.trackingEntityAndSelf(() -> entity));
    }

    public static void sendTo(CustomPacket message, class_3222 player) {
        dispatcher.split(message, distributors.player(() -> player));
    }

    public static void sendToServer(CustomPacket message) {
        dispatcher.split(message, distributors.server());
    }

    public static void sendToAll(CustomPacket message) {
        dispatcher.split(message, distributors.allPlayers());
    }

    public static void sendWardrobeTo(class_1297 entity, class_3222 player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            wardrobe.broadcast(player);
        }
    }

    public static <R> void sendTo(CustomReplyPacket<R> message, class_3222 player, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendTo(message, player);
    }

    public static <R> void sendToServer(CustomReplyPacket<R> message, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendToServer(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dispatcher createDispatcher(IResourceLocation registryName, String version) {
        void var1_1;
        return NetworkManagerImpl.createDispatcher(registryName, (String)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Distributors createDistributors() {
        return NetworkManagerImpl.createDistributors();
    }

    public static abstract class Dispatcher {
        protected final UUID clientUUID = UUID.randomUUID();
        protected final String channelVersion;
        protected final IResourceLocation channelName;
        protected final PacketSplitter splitter;

        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            this.channelName = channelName;
            this.channelVersion = channelVersion;
            this.splitter = new PacketSplitter();
        }

        public abstract void register();

        public void didReceivePacket(IServerPacketHandler packetHandler, IFriendlyByteBuf payload, class_3222 player) {
            this.merge(player.method_5667(), payload, packet -> packetHandler.enqueueWork(() -> packet.accept(packetHandler, player)));
        }

        @Environment(value=EnvType.CLIENT)
        public void didReceivePacket(IClientPacketHandler packetHandler, IFriendlyByteBuf payload, class_1657 player) {
            this.merge(this.clientUUID, payload, packet -> packetHandler.enqueueWork(() -> packet.accept(packetHandler, EnvironmentManager.getPlayer())));
        }

        public void merge(UUID uuid, IFriendlyByteBuf buffer, Consumer<CustomPacket> consumer) {
            this.splitter.merge(uuid, buffer, consumer);
        }

        public void split(CustomPacket message, IPacketDistributor distributor) {
            int partSize = this.getMaximumPayloadSize(distributor) - 256;
            this.splitter.split(message, buf -> distributor.add(this.channelName, (IFriendlyByteBuf)buf), partSize, IPacketDistributor::execute);
        }

        public int getMaximumPayloadSize(IPacketDistributor distributor) {
            if (distributor.isClientbound()) {
                return 0x100000;
            }
            return 32768;
        }
    }

    public static interface Distributors {
        public IPacketDistributor trackingChunk(Supplier<class_2818> var1);

        public IPacketDistributor trackingEntityAndSelf(Supplier<class_1297> var1);

        public IPacketDistributor player(Supplier<class_3222> var1);

        public IPacketDistributor allPlayers();

        public IPacketDistributor server();
    }
}

