/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.fabric.config;

import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfig;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigEvents;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.file.CommentedFileConfig;

public class FabricConfigTracker {
    public static final FabricConfigTracker INSTANCE = new FabricConfigTracker();
    private final ConcurrentHashMap<String, FabricConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<FabricConfig.Type, Set<FabricConfig>> configSets = new EnumMap(FabricConfig.Type.class);
    private final ConcurrentHashMap<String, Map<FabricConfig.Type, FabricConfig>> configsByMod = new ConcurrentHashMap();

    private FabricConfigTracker() {
        this.configSets.put(FabricConfig.Type.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(FabricConfig.Type.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(FabricConfig.Type.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(FabricConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            ModLog.error("Detected config file conflict {} between {} and {}", config.getFileName(), this.fileMap.get(config.getFileName()).getModId(), config.getModId());
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(FabricConfig.Type.class)).put(config.getType(), config);
        ModLog.debug("Config file {} for {} tracking", config.getFileName(), config.getModId());
    }

    public void loadConfigs(FabricConfig.Type type, Path configBasePath) {
        ModLog.debug("Loading configs type {}", new Object[]{type});
        this.configSets.get((Object)type).forEach(config -> this.openConfig((FabricConfig)config, configBasePath));
    }

    public void unloadConfigs(FabricConfig.Type type, Path configBasePath) {
        ModLog.debug("Unloading configs type {}", new Object[]{type});
        this.configSets.get((Object)type).forEach(config -> this.closeConfig((FabricConfig)config, configBasePath));
    }

    private void openConfig(FabricConfig config, Path configBasePath) {
        ModLog.debug("Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        CommentedFileConfig configData = config.getHandler().reader(configBasePath).apply(config);
        config.setConfigData(configData);
        ((FabricConfigEvents.OnUpdate)FabricConfigEvents.LOADING.invoker()).config(config);
        config.save();
    }

    private void closeConfig(FabricConfig config, Path configBasePath) {
        if (config.getConfigData() != null) {
            ModLog.debug("Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            config.save();
            config.getHandler().unload(configBasePath, config);
            config.setConfigData(null);
        }
    }
}

