/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.common.IMenuSerializer;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractEntityDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import org.apache.logging.log4j.util.Strings;

public class DataSerializers {
    public static final IDataCodec<IResourceLocation> RESOURCE_LOCATION = IDataCodec.STRING.xmap(OpenResourceLocation::parse, (Function<IResourceLocation, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lmoe/plushie/armourers_workshop/api/core/IResourceLocation;)Ljava/lang/String;)());
    public static final IDataCodec<OpenRectangle3f> BOUNDING_BOX = IDataCodec.FLOAT.listOf().xmap(OpenRectangle3f::new, OpenRectangle3f::toList);
    public static final IDataCodec<SkinPaintData> COMPRESSED_PAINT_DATA = IDataCodec.BYTE_BUFFER.xmap(DataSerializers::decompressPaintData, DataSerializers::compressPaintData);
    public static final IDataCodec<EntityTextureDescriptor.Model> ENTITY_TEXTURE_MODEL = IDataCodec.INT.xmap(DataSerializers::parseTextureModel, Enum::ordinal);
    public static final IEntitySerializer<class_2487> COMPOUND_TAG = DataSerializers.of(class_2943.field_13318);
    public static final IEntitySerializer<Integer> INT = DataSerializers.of(class_2943.field_13327);
    public static final IEntitySerializer<String> STRING = DataSerializers.of(class_2943.field_13326);
    public static final IEntitySerializer<Boolean> BOOLEAN = DataSerializers.of(class_2943.field_13323);
    public static final IEntitySerializer<Float> FLOAT = DataSerializers.of(class_2943.field_13320);
    public static final IEntitySerializer<class_243> VECTOR_3D = new IEntitySerializer<class_243>(){

        @Override
        public void write(IFriendlyByteBuf buffer, class_243 pos) {
            buffer.writeDouble(pos.method_10216());
            buffer.writeDouble(pos.method_10214());
            buffer.writeDouble(pos.method_10215());
        }

        @Override
        public class_243 read(IFriendlyByteBuf buffer) {
            return new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final IEntitySerializer<OpenVector3f> VECTOR_3F = new IEntitySerializer<OpenVector3f>(){

        @Override
        public void write(IFriendlyByteBuf buffer, OpenVector3f pos) {
            buffer.writeFloat(pos.x());
            buffer.writeFloat(pos.y());
            buffer.writeFloat(pos.z());
        }

        @Override
        public OpenVector3f read(IFriendlyByteBuf buffer) {
            return new OpenVector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final IEntitySerializer<SkinPaintColor> PAINT_COLOR = new IEntitySerializer<SkinPaintColor>(){

        @Override
        public void write(IFriendlyByteBuf buffer, SkinPaintColor color) {
            buffer.writeInt(color.rawValue());
        }

        @Override
        public SkinPaintColor read(IFriendlyByteBuf buffer) {
            return SkinPaintColor.of(buffer.readInt());
        }
    };
    public static final IEntitySerializer<EntityTextureDescriptor> PLAYER_TEXTURE = new IEntitySerializer<EntityTextureDescriptor>(){

        @Override
        public void write(IFriendlyByteBuf buffer, EntityTextureDescriptor descriptor) {
            buffer.writeNbtWithCodec(EntityTextureDescriptor.CODEC, descriptor);
        }

        @Override
        public EntityTextureDescriptor read(IFriendlyByteBuf buffer) {
            return buffer.readNbtWithCodec(EntityTextureDescriptor.CODEC);
        }
    };
    public static final IEntitySerializer<EntityTextureDescriptor.Model> PLAYER_TEXTURE_MODEL = new IEntitySerializer<EntityTextureDescriptor.Model>(){

        @Override
        public void write(IFriendlyByteBuf buffer, EntityTextureDescriptor.Model descriptor) {
            buffer.writeInt(descriptor.ordinal());
        }

        @Override
        public EntityTextureDescriptor.Model read(IFriendlyByteBuf buffer) {
            return EntityTextureDescriptor.Model.values()[buffer.readInt()];
        }
    };
    public static final IEntitySerializer<EntityCollisionShape> COLLISION_SHAPE_OPT = new IEntitySerializer<EntityCollisionShape>(){

        @Override
        public EntityCollisionShape read(IFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            if (size == 0) {
                return null;
            }
            ArrayList<Float> values = new ArrayList<Float>();
            for (int i = 0; i < size; ++i) {
                values.add(Float.valueOf(buffer.readFloat()));
            }
            return new EntityCollisionShape(values);
        }

        @Override
        public void write(IFriendlyByteBuf buffer, EntityCollisionShape shape) {
            List<Float> values = Objects.flatMap(shape, EntityCollisionShape::toList);
            if (values == null) {
                values = Collections.emptyList();
            }
            buffer.writeVarInt(values.size());
            for (Float value : values) {
                buffer.writeFloat(value.floatValue());
            }
        }
    };
    public static final IEntitySerializer<Exception> EXCEPTION = new IEntitySerializer<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(IFriendlyByteBuf buffer, Exception exception) {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                boolean compress = ModConfig.Common.enableServerCompressesSkins;
                buffer.writeBoolean(compress);
                outputStream = this.createOutputStream(buffer, compress);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(exception);
            }
            catch (Exception exception1) {
                try {
                    exception1.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectOutputStream, outputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception read(IFriendlyByteBuf buffer) {
            Exception exception;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                boolean compress = buffer.readBoolean();
                inputStream = this.createInputStream(buffer, compress);
                objectInputStream = new ObjectInputStream(inputStream);
                exception = (Exception)objectInputStream.readObject();
            }
            catch (Exception exception2) {
                Exception exception3;
                try {
                    exception3 = exception2;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectInputStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                return exception3;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception;
        }

        public Exception copy(Exception value) {
            return value;
        }

        private InputStream createInputStream(IFriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream(buffer.asByteBuf());
            if (compress) {
                return new GZIPInputStream((InputStream)inputStream);
            }
            return inputStream;
        }

        private OutputStream createOutputStream(IFriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer.asByteBuf());
            if (compress) {
                return new GZIPOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }
    };
    public static final IMenuSerializer<SkinWardrobe> ENTITY_WARDROBE = new IMenuSerializer<SkinWardrobe>(){

        @Override
        public void write(IFriendlyByteBuf buffer, class_1657 player, SkinWardrobe wardrobe) {
            buffer.writeInt(wardrobe.id());
            buffer.writeResourceLocation(wardrobe.profile().registryName());
        }

        @Override
        public SkinWardrobe read(IFriendlyByteBuf buffer, class_1657 player) {
            if (player == null || player.method_37908() == null) {
                return null;
            }
            int entityId = buffer.readInt();
            class_1297 entity = player.method_37908().method_8469(entityId);
            if (entity == null) {
                for (class_1657 player1 : player.method_37908().method_18456()) {
                    if (player1.method_5628() != entityId) continue;
                    entity = player1;
                    break;
                }
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            EntityProfile serverProfile = ModEntityProfiles.getProfile(buffer.readResourceLocation());
            if (wardrobe != null && serverProfile != null) {
                wardrobe.setProfile(serverProfile);
            }
            return wardrobe;
        }
    };
    public static final IMenuSerializer<IGlobalPos> GLOBAL_POS = new IMenuSerializer<IGlobalPos>(){

        @Override
        public void write(IFriendlyByteBuf buffer, class_1657 player, IGlobalPos callable) {
            Optional<class_2338> pos1 = callable.evaluate((world, pos) -> pos);
            buffer.writeBlockPos(pos1.orElse(class_2338.field_10980));
        }

        @Override
        public IGlobalPos read(IFriendlyByteBuf buffer, class_1657 player) {
            if (player == null || player.method_37908() == null) {
                return null;
            }
            class_2338 blockPos = buffer.readBlockPos();
            return IGlobalPos.create(player.method_37908(), blockPos);
        }
    };
    public static final IPlayerDataSerializer<SkinType> SKIN_TYPE = new IPlayerDataSerializer<SkinType>(){

        @Override
        public void write(IFriendlyByteBuf buffer, class_1657 player, SkinType value) {
            buffer.writeUtf(value.registryName().toString());
        }

        @Override
        public SkinType read(IFriendlyByteBuf buffer, class_1657 player) {
            return SkinTypes.byName(buffer.readUtf());
        }
    };
    public static final IPlayerDataSerializer<SkinProperties> SKIN_PROPERTIES = new IPlayerDataSerializer<SkinProperties>(){

        @Override
        public void write(IFriendlyByteBuf buffer, class_1657 player, SkinProperties value) {
            class_2487 nbt = new class_2487();
            value.writeToNBT(nbt);
            buffer.writeNbt(nbt);
        }

        @Override
        public SkinProperties read(IFriendlyByteBuf buffer, class_1657 player) {
            SkinProperties properties = new SkinProperties();
            class_2487 nbt = buffer.readNbt();
            if (nbt != null) {
                properties.readFromNBT(nbt);
            }
            return properties;
        }
    };
    private static final Random RANDOM = new Random();

    public static <T> IEntitySerializer<T> of(class_2941<T> serializer) {
        return AbstractEntityDataSerializer.wrap(serializer);
    }

    public static GameProfile readGameProfile(class_2487 tag) {
        try {
            String name = OptionalAPI.getOptionalString(tag, "Name").orElse(null);
            UUID id = OptionalAPI.getOptionalUUID(tag, "Id").orElse(null);
            return new GameProfile(id, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static class_2487 writeGameProfile(class_2487 tag, GameProfile value) {
        if (value == null) {
            return tag;
        }
        if (Strings.isNotBlank((String)value.getName())) {
            tag.method_10582("Name", value.getName());
        }
        if (value.getId() != null) {
            tag.method_25927("Id", value.getId());
        }
        return tag;
    }

    public static void dropContents(class_1937 level, class_2338 blockPos, class_1263 container) {
        DataSerializers.dropContents(level, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), container);
    }

    public static void dropContents(class_1937 level, class_1297 entity, class_1263 container) {
        DataSerializers.dropContents(level, entity.method_23317(), entity.method_23318(), entity.method_23321(), container);
    }

    private static void dropContents(class_1937 level, double x, double y, double z, class_1263 container) {
        for (int i = 0; i < container.method_5439(); ++i) {
            DataSerializers.dropItemStack(level, x, y, z, container.method_5438(i));
        }
    }

    public static void dropContents(class_1937 level, class_2338 blockPos, List<class_1799> itemStacks) {
        itemStacks.forEach(itemStack -> DataSerializers.dropItemStack(level, blockPos, itemStack));
    }

    public static void dropItemStack(class_1937 level, class_2338 blockPos, class_1799 itemStack) {
        DataSerializers.dropItemStack(level, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), itemStack);
    }

    public static void dropItemStack(class_1937 level, double x, double y, double z, class_1799 itemStack) {
        double d0 = class_1299.field_6052.method_17685();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!itemStack.method_7960()) {
            class_1542 itementity = new class_1542(level, d3, d4, d5, itemStack.method_7971(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.method_18800(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            level.method_8649((class_1297)itementity);
        }
    }

    public static SkinPaintData decompressPaintData(ByteBuffer buffer) {
        SkinPaintData skinPaintData;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.array());
        DataInputStream dataStream = new DataInputStream(new GZIPInputStream(inputStream));
        try {
            SkinPaintData paintData = SkinPaintData.v2(false);
            int length = dataStream.readInt();
            int[] colors = paintData.bytes();
            for (int i = 0; i < length; ++i) {
                if (i >= colors.length) continue;
                colors[i] = dataStream.readInt();
            }
            skinPaintData = paintData;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return null;
            }
        }
        dataStream.close();
        return skinPaintData;
    }

    public static ByteBuffer compressPaintData(SkinPaintData paintData) {
        ByteBuffer throwable2;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(new GZIPOutputStream(outputStream));
        try {
            int[] colors = paintData.bytes();
            dataStream.writeInt(colors.length);
            for (int color : colors) {
                dataStream.writeInt(color);
            }
            dataStream.close();
            throwable2 = ByteBuffer.wrap(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataStream.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        dataStream.close();
        return throwable2;
    }

    public static EntityTextureDescriptor.Model parseTextureModel(int index) {
        EntityTextureDescriptor.Model[] values = EntityTextureDescriptor.Model.values();
        if (index < values.length) {
            return values[index];
        }
        return EntityTextureDescriptor.Model.STEVE;
    }
}

