/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.impl.ObjectUtilsImpl;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public interface CGGraphicsState {
    public IPoseStack ctm();

    public IBufferSource bufferSource();

    public CGPoint mousePos();

    public float partialTicks();

    public void flush();

    default public void save() {
        this.ctm().pushPose();
    }

    default public void translate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.ctm().translate(x, y, z);
        }
    }

    default public void scale(float x, float y, float z) {
        if (x != 1.0f || y != 1.0f || z != 1.0f) {
            this.ctm().scale(x, y, z);
        }
    }

    default public void rotate(float x, float y, float z) {
        if (x != 0.0f) {
            this.ctm().rotate(OpenVector3f.XP.rotationDegrees(x));
        }
        if (y != 0.0f) {
            this.ctm().rotate(OpenVector3f.YP.rotationDegrees(y));
        }
        if (z != 0.0f) {
            this.ctm().rotate(OpenVector3f.ZP.rotationDegrees(z));
        }
    }

    default public void concatenate(CGAffineTransform transform) {
        IPoseStack ctm = this.ctm();
        ctm.multiply(ObjectUtilsImpl.convertToMatrix3x3(transform));
        ctm.multiply(ObjectUtilsImpl.convertToMatrix4x4(transform));
    }

    default public void restore() {
        this.ctm().popPose();
    }
}

