/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.api.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.registry.IRegistryBuilder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public interface IBlockBuilder<T extends Block>
extends IRegistryBuilder<T> {
    public IBlockBuilder<T> noCollission();

    public IBlockBuilder<T> noOcclusion();

    public IBlockBuilder<T> noDrops();

    public IBlockBuilder<T> friction(float var1);

    public IBlockBuilder<T> speedFactor(float var1);

    public IBlockBuilder<T> jumpFactor(float var1);

    public IBlockBuilder<T> sound(SoundType var1);

    public IBlockBuilder<T> lightLevel(ToIntFunction<BlockState> var1);

    public IBlockBuilder<T> strength(float var1, float var2);

    public IBlockBuilder<T> randomTicks();

    public IBlockBuilder<T> dynamicShape();

    public IBlockBuilder<T> air();

    public IBlockBuilder<T> forceSolid();

    public IBlockBuilder<T> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> var1);

    public IBlockBuilder<T> isRedstoneConductor(BlockBehaviour.StatePredicate var1);

    public IBlockBuilder<T> isSuffocating(BlockBehaviour.StatePredicate var1);

    public IBlockBuilder<T> isViewBlocking(BlockBehaviour.StatePredicate var1);

    public IBlockBuilder<T> hasPostProcess(BlockBehaviour.StatePredicate var1);

    public IBlockBuilder<T> emissiveRendering(BlockBehaviour.StatePredicate var1);

    public IBlockBuilder<T> requiresCorrectToolForDrops();

    public IBlockBuilder<T> bind(Supplier<Supplier<IRenderType>> var1);

    default public IBlockBuilder<T> lightLevel(int level) {
        return this.lightLevel(state -> level);
    }
}

