/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.builder.item.AbstractPaintToolItem;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.network.UpdateColorPickerPacket;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ColorPickerItem
extends AbstractPaintToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemPaintable,
IPaintToolPicker,
IBlockPaintViewer {
    public ColorPickerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.usePickTool(context);
    }

    @Override
    public InteractionResult usePickTool(Level level, BlockPos pos, OpenDirection dir, BlockEntity blockEntity, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (blockEntity instanceof IBlockPaintable) {
            IBlockPaintable paintable = (IBlockPaintable)blockEntity;
            if (!level.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            SkinPaintColor color = paintable.getColor(dir);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), color);
            UpdateColorPickerPacket packet = new UpdateColorPickerPacket(context.m_43724_(), itemStack);
            NetworkManager.sendToServer(packet);
            this.playSound(context);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            Player player = context.m_43723_();
            if (player != null && !player.m_36341_()) {
                return InteractionResult.PASS;
            }
            SkinPaintColor newColor = this.getItemColor(itemStack);
            if (newColor == null) {
                return InteractionResult.CONSUME;
            }
            if (!ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE).booleanValue()) {
                newColor = newColor.withPaintType(provider.color().paintType());
            }
            provider.setColor(newColor);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get()) ? 0.0f : 1.0f);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<Component> tooltips) {
        SkinPaintColor paintColor = this.getItemColor(itemStack);
        if (paintColor != null) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor, false));
        } else {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.empty", new Object[0]));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, SkinPaintColor paintColor) {
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
    }

    @Override
    public SkinPaintColor getItemColor(ItemStack itemStack) {
        return (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    public boolean m_5812_(ItemStack itemStack) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        return paintColor.paintType() != SkinPaintTypes.NORMAL;
    }

    @Override
    public IRegistryHolder<SoundEvent> getItemSoundEvent(UseOnContext context) {
        return ModSounds.PICKER;
    }
}

