/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.time.Duration;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSourceImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import moe.plushie.armourers_workshop.core.data.cache.CacheQueue;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class AbstractBufferSource
implements IBufferSource {
    private static final AbstractBufferSource DEFAULT = AbstractBufferSource.create(AbstractBufferSourceImpl::bufferSource);
    private static final AbstractBufferSource OUTLINE = AbstractBufferSource.create(AbstractBufferSourceImpl::outlineBufferSource);
    private static final AbstractBufferSource TESSELATOR = AbstractBufferSource.create(80000);
    private static final CacheQueue<Object, AbstractBufferSource> CACHED_BUFFER_SOURCES = new CacheQueue(Duration.ofSeconds(30L));
    private static final CacheQueue<VertexConsumer, IVertexConsumer> CACHED_BUFFER_BUILDERS = new CacheQueue(Duration.ofSeconds(30L));
    private final Supplier<MultiBufferSource> bufferSourceProvider;

    private AbstractBufferSource(Supplier<MultiBufferSource> bufferSourceProvider) {
        this.bufferSourceProvider = bufferSourceProvider;
    }

    public static AbstractBufferSource buffer() {
        return DEFAULT;
    }

    public static AbstractBufferSource outline() {
        return OUTLINE;
    }

    public static AbstractBufferSource tesselator() {
        return TESSELATOR;
    }

    public static AbstractBufferSource create(int size) {
        return AbstractBufferSource.create(AbstractBufferSourceImpl.immediateSource(size));
    }

    public static AbstractBufferSource create(MultiBufferSource bufferSource) {
        return AbstractBufferSource.create(() -> bufferSource);
    }

    public static AbstractBufferSource create(Supplier<MultiBufferSource> bufferSourceProvider) {
        return new AbstractBufferSource(bufferSourceProvider);
    }

    public static AbstractBufferSource wrap(MultiBufferSource bufferSource) {
        AbstractBufferSource bufferSource1 = CACHED_BUFFER_SOURCES.get(bufferSource);
        if (bufferSource1 == null) {
            bufferSource1 = AbstractBufferSource.create(bufferSource);
            CACHED_BUFFER_SOURCES.put(bufferSource, bufferSource1);
        }
        return bufferSource1;
    }

    public static MultiBufferSource unwrap(IBufferSource bufferSource) {
        return ((AbstractBufferSource)bufferSource).bufferSource();
    }

    @Override
    public IVertexConsumer getBuffer(IRenderType renderType) {
        VertexConsumer builder = this.bufferSource().m_6299_((RenderType)renderType.get());
        return CACHED_BUFFER_BUILDERS.computeIfAbsent(builder, AbstractVertexConsumer::of);
    }

    @Override
    public void endBatch() {
        MultiBufferSource multiBufferSource = this.bufferSource();
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource1 = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource1.m_109911_();
        }
    }

    public MultiBufferSource bufferSource() {
        return this.bufferSourceProvider.get();
    }
}

