/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.RenderType.ColorLogicProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class AbstractRenderTypeImpl
extends RenderType {
    private static final Map<SkinVertexFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderTypeImpl._make(it -> {
        it.put(SkinVertexFormat.LINE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.DEBUG_LINES, f_173104_));
        it.put(SkinVertexFormat.LINE_STRIP, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.DEBUG_LINE_STRIP, f_173104_));
        it.put(SkinVertexFormat.IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, f_173103_).overlay().lightmap());
        it.put(SkinVertexFormat.BLIT_MASK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, f_173104_));
        it.put(SkinVertexFormat.GUI_COLOR, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, f_173104_));
        it.put(SkinVertexFormat.GUI_IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, f_173102_));
        it.put(SkinVertexFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, f_173100_));
        it.put(SkinVertexFormat.BLOCK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_));
        it.put(SkinVertexFormat.BLOCK_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_));
        it.put(SkinVertexFormat.ENTITY_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_));
        it.put(SkinVertexFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173114_));
        it.put(SkinVertexFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173065_));
        it.put(SkinVertexFormat.ENTITY_ALPHA, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173072_));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173071_).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173071_).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173074_).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173074_).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.TRIANGLES, f_173113_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.TRIANGLES, f_173074_).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.TRIANGLES, f_173112_).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.TRIANGLES, f_173074_).overlay().lightmap().emissive());
    });

    public AbstractRenderTypeImpl(String name, RenderType delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.m_110508_(), delegate.m_173186_(), delegate.m_110507_(), affectsCrumbling, sortUpload, () -> {
            delegate.m_110185_();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.m_110188_();
        });
    }

    public static IRenderTypeBuilder builder(SkinVertexFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            IRenderTypeBuilder builder = provider.get();
            if (builder instanceof Builder) {
                Builder builder1 = (Builder)builder;
                builder1.format(format);
            }
            return builder;
        }
        throw new RuntimeException("can't supported render mode");
    }

    private static Builder _builder(VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder.m_173292_(shader);
        return builder;
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    extends AbstractRenderType.Builder {
        private static final Map<IRenderType.Texturing, RenderStateShard.TexturingStateShard> TABLE_TEXTURING = AbstractRenderTypeImpl._make(it -> {});
        private static final Map<IRenderType.Target, RenderStateShard.OutputStateShard> TABLE_OUTPUT = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Target.MAIN, f_110123_);
            it.put(IRenderType.Target.OUTLINE, f_110124_);
            it.put(IRenderType.Target.TRANSLUCENT, f_110125_);
            it.put(IRenderType.Target.CLOUDS, f_110128_);
            it.put(IRenderType.Target.WEATHER, f_110127_);
            it.put(IRenderType.Target.PARTICLES, f_110126_);
            it.put(IRenderType.Target.ITEM_ENTITY, f_110129_);
        });
        private static final Map<IRenderType.Transparency, RenderStateShard.TransparencyStateShard> TABLE_TRANSPARENCY = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Transparency.DEFAULT, f_110139_);
            it.put(IRenderType.Transparency.TRANSLUCENT, f_110139_);
            it.put(IRenderType.Transparency.NONE, f_110134_);
        });
        private static final Map<IRenderType.WriteMask, RenderStateShard.WriteMaskStateShard> TABLE_WRITE_MASK = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.WriteMask.NONE, new RenderStateShard.WriteMaskStateShard(false, false));
            it.put(IRenderType.WriteMask.COLOR_DEPTH_WRITE, f_110114_);
            it.put(IRenderType.WriteMask.COLOR_WRITE, f_110115_);
            it.put(IRenderType.WriteMask.DEPTH_WRITE, f_110116_);
        });
        private static final Map<IRenderType.DepthTest, RenderStateShard.DepthTestStateShard> TABLE_DEPTH_TEST = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.DepthTest.NONE, f_110111_);
            it.put(IRenderType.DepthTest.EQUAL, f_110112_);
            it.put(IRenderType.DepthTest.LESS_EQUAL, f_110113_);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        RenderType.CompositeState.CompositeStateBuilder stateBuilder = RenderType.CompositeState.m_110628_();
        final VertexFormat format;
        final VertexFormat.Mode mode;

        private Builder(VertexFormat format, VertexFormat.Mode mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            this.stateBuilder = this.stateBuilder.m_110661_(f_110110_);
        }

        @Override
        public IRenderTypeBuilder texture(IResourceLocation texture, boolean blur, boolean mipmap) {
            this.stateBuilder = this.stateBuilder.m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture.toLocation(), blur, mipmap));
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderType.Texturing texturing) {
            this.stateBuilder = this.stateBuilder.m_110683_(TABLE_TEXTURING.getOrDefault((Object)texturing, f_110148_));
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderType.Target target) {
            this.stateBuilder = this.stateBuilder.m_110675_(TABLE_OUTPUT.getOrDefault((Object)target, f_110123_));
            return super.target(target);
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderType.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.m_110685_(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, f_110134_));
            return super.transparency(transparency);
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderType.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.m_110687_(TABLE_WRITE_MASK.getOrDefault((Object)mask, f_110114_));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderType.DepthTest test) {
            this.stateBuilder = this.stateBuilder.m_110663_(TABLE_DEPTH_TEST.getOrDefault((Object)test, f_110111_));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderType.ColorLogic state) {
            this.stateBuilder = ColorLogicProvider.CompositeState.CompositeStateBuilder.setColorLogicState(this.stateBuilder, state);
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.m_110669_(new RenderStateShard.LayeringStateShard("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.m_110669_(new RenderStateShard.LayeringStateShard("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.m_110661_(f_110158_);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.m_110671_(f_110152_);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.m_110677_(f_110154_);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public IRenderType build(String name) {
            AbstractRenderType renderType = AbstractRenderType.of((RenderType)RenderType.m_173215_((String)name, (VertexFormat)this.format, (VertexFormat.Mode)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (RenderType.CompositeState)this.stateBuilder.m_110691_(this.isOutline)));
            renderType.apply(this.updater);
            return renderType;
        }

        public Builder or(Function<RenderType.CompositeState.CompositeStateBuilder, RenderType.CompositeState.CompositeStateBuilder> builder) {
            this.stateBuilder = builder.apply(this.stateBuilder);
            return this;
        }
    }
}

