/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDeltaTracker;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.CustomRiddingProvider;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;

public class AbstractVehicleUpdater {
    private static final AbstractVehicleUpdater INSTANCE = new AbstractVehicleUpdater();
    private final Int2ObjectMap<Entity> entities = new Int2ObjectOpenHashMap();
    private Int2ObjectMap<Entity> active;

    private AbstractVehicleUpdater() {
        EventBus.register(RenderFrameEvent.Pre.class, event -> this.update(event.getDeltaTracker()));
    }

    public static AbstractVehicleUpdater getInstance() {
        return INSTANCE;
    }

    public void submit(Entity entity) {
        this.active = this.entities;
        this.entities.put(entity.m_19879_(), (Object)entity);
    }

    private void update(AbstractDeltaTracker delta) {
        if (this.active == null) {
            return;
        }
        ArrayList<Entity> oldValue = new ArrayList<Entity>((Collection<Entity>)this.entities.values());
        this.active = null;
        this.entities.clear();
        oldValue.forEach(it -> this.apply((Entity)it, delta.getPartialTick((Entity)it)));
    }

    private void apply(Entity entity, float partialTicks) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        List passengers = entity.m_20197_();
        for (int index = 0; index < passengers.size(); ++index) {
            SkinAttachmentPose attachmentPose = renderData.getAttachmentPose(SkinAttachmentTypes.RIDING, index);
            if (attachmentPose == null) continue;
            Entity passenger = (Entity)passengers.get(index);
            this.apply(entity, partialTicks, index, passenger, attachmentPose);
        }
    }

    private void apply(Entity entity, float partialTicks, int index, Entity passenger, SkinAttachmentPose pose) {
        float scale = this.getRiddingScale(entity);
        OpenMatrix4f mat = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        mat.rotate(OpenVector3f.YP.rotationDegrees(180.0f - entity.m_5675_(partialTicks)));
        mat.scale(-1.0f, -1.0f, 1.0f);
        mat.scale(scale, scale, scale);
        mat.translate(0.0f, -1.501f, 0.0f);
        mat.scale(0.0625f, 0.0625f, 0.0625f);
        mat.multiply(pose.pose());
        OpenVector3f offset = OpenVector3f.ZERO.transforming(mat);
        CustomRiddingProvider.setCustomRidding(entity, index, offset);
        double tx = passenger.m_20185_();
        double ty = passenger.m_20186_();
        double tz = passenger.m_20189_();
        entity.m_7332_(passenger);
        double dx = passenger.m_20185_() - tx;
        double dy = passenger.m_20186_() - ty;
        double dz = passenger.m_20189_() - tz;
        passenger.f_19854_ += dx;
        passenger.f_19855_ += dy;
        passenger.f_19856_ += dz;
        passenger.f_19790_ += dx;
        passenger.f_19791_ += dy;
        passenger.f_19792_ += dz;
    }

    private float getRiddingScale(Entity entity) {
        if (entity instanceof Horse) {
            return 1.1f;
        }
        return 1.0f;
    }
}

