/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.EntityRendererImpl;
import com.apple.library.uikit.UIFont;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRendererImpl;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private final GuiGraphics graphics;
    private final CGPoint mousePos;
    private final IPoseStack poseStack;
    private final IBufferSource bufferSource;
    private final float partialTicks;

    public AbstractGraphicsRenderer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.graphics = graphics;
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.poseStack = AbstractPoseStack.wrap(graphics.m_280168_());
        this.bufferSource = AbstractBufferSource.wrap((MultiBufferSource)graphics.m_280091_());
        this.partialTicks = partialTicks;
    }

    public static GuiGraphics of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)Objects.unsafeCast(context.state());
        return impl.graphics;
    }

    public static CGGraphicsContext of(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(graphics, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, UIFont font, CGGraphicsContext context) {
        Font font1 = font.impl();
        List texts = font1.m_92923_((FormattedText)text.component(), 100000);
        this.graphics.m_280245_(font1, texts, (int)this.mousePos.x(), (int)this.mousePos.y());
    }

    @Override
    public void renderTooltip(ItemStack itemStack, CGRect rect, UIFont font, CGGraphicsContext context) {
        Font font1 = font.impl();
        this.graphics.m_280153_(font1, itemStack, (int)this.mousePos.x(), (int)this.mousePos.y());
    }

    @Override
    public void renderEntity(Entity entity, CGPoint origin, int scale, CGPoint focus, CGGraphicsContext context) {
        EntityRendererImpl<Entity> renderer = AbstractGraphicsRendererImpl.getRenderer(entity);
        renderer.render(entity, origin, scale, focus, context);
    }

    @Override
    public void renderItem(ItemStack itemStack, int x, int y, CGGraphicsContext context) {
        this.graphics.m_280203_(itemStack, x, y);
    }

    @Override
    public void flush() {
        this.graphics.m_280262_();
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public IBufferSource bufferSource() {
        return this.bufferSource;
    }

    @Override
    public IPoseStack ctm() {
        return this.poseStack;
    }
}

