/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPartCollector;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelCollector;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelPartHolder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.Model.BabyPose;
import moe.plushie.armourers_workshop.core.client.model.CachedModel;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractModelHolder {
    private static final HashMap<Class<?>, Entry<?, ?>> ENTRIES = new HashMap();

    public static <V extends Model, M extends IModel> M ofNullable(V model) {
        if (model != null) {
            return AbstractModelHolder.of(model);
        }
        return null;
    }

    public static <M extends IModel> M of(Model model) {
        IModel holder = DataContainer.getOrDefault(model, null);
        if (holder != null) {
            return (M)holder;
        }
        holder = AbstractModelHolder.createHolder(model);
        DataContainer.set(model, holder);
        return (M)holder;
    }

    public static <T extends Model> void register(Class<T> clazz, Map<String, String> mapper) {
        ENTRIES.put(clazz, new Entry(clazz, null, AbstractModelCollector.apply(clazz, mapper)));
    }

    private static <V extends Model, M extends IModel> M createHolder(V model) {
        HashSet<Entry<V, M>> exists = new HashSet<Entry<V, M>>();
        ArrayList<Map> builders = new ArrayList<Map>();
        Function factory = null;
        for (Class<?> clazz = model.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Entry<V, M> entry = AbstractModelHolder.getEntry(clazz);
            if (entry == null || !exists.add(entry)) continue;
            builders.add(entry.mapper);
            if (factory != null) continue;
            factory = entry.factory;
        }
        if (factory == null) {
            Function<Container, CachedModel> factory1 = CachedModel::new;
            factory = (Function)Objects.unsafeCast(factory1);
        }
        Container container = new Container(model);
        Map<String, ModelPart> allParts = AbstractModelHolder.parseModel(model);
        builders.forEach(mapper -> mapper.forEach((target, source) -> {
            ModelPart part = (ModelPart)allParts.remove(source);
            if (part != null) {
                container.put((String)target, part);
            }
        }));
        allParts.forEach((key, part) -> {
            if (!key.contains(".")) {
                container.unnamed(Collections.singleton(part));
            }
        });
        return (M)((IModel)factory.apply(container));
    }

    private static <V extends Model, M extends IModel> Entry<V, M> getEntry(Class<?> clazz) {
        Entry<Object, Object> entry = ENTRIES.get(clazz);
        if (entry == null) {
            if (clazz == Object.class) {
                return null;
            }
            entry = AbstractModelHolder.getEntry(clazz.getSuperclass());
            ENTRIES.put(clazz, entry);
        }
        return (Entry)Objects.unsafeCast(entry);
    }

    private static Map<String, ModelPart> parseModel(Model model) {
        LinkedHashMap<String, ModelPart> allParts = new LinkedHashMap<String, ModelPart>();
        if (model instanceof IModelPartCollector) {
            IModelPartCollector provider = (IModelPartCollector)model;
            provider.aw2$collect(allParts);
        }
        return allParts;
    }

    private static class Entry<T extends Model, M extends IModel> {
        Class<T> clazz;
        Function<Container, M> factory;
        Map<String, String> mapper;

        Entry(Class<T> clazz, Function<Container, M> factory, Map<String, String> mapper) {
            this.clazz = clazz;
            this.factory = factory;
            this.mapper = mapper;
        }
    }

    private static class Container
    extends CachedModel.Container<ModelPart> {
        private final EntityModel<?> model;

        public Container(Model model) {
            super(model.getClass(), AbstractModelPartHolder::of);
            this.model = Objects.safeCast(model, EntityModel.class);
            this.babyPose = BabyPose.getBabyPose(model);
        }

        @Override
        public IModelBabyPose babyPose() {
            if (this.model != null && this.model.f_102610_) {
                return super.babyPose();
            }
            return null;
        }
    }
}

