/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.mixin.dynamiclight;

import moe.plushie.armourers_workshop.core.client.other.SkinLightSource;
import moe.plushie.armourers_workshop.init.client.ClientDynamicLightHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ForgeLambDynamicLightsMixin {

    @Pseudo
    @Mixin(targets={"dev.lambdaurora.lambdynlights.resource.entity.BlockEntityLightSources"})
    public static class BlockEntityLightHandler {
        @Inject(method={"getLuminance"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private void aw2$getLuminance(BlockEntity entity, CallbackInfoReturnable<Integer> cir) {
            SkinLightSource lightSource = ClientDynamicLightHandler.getLightSource(entity);
            if (lightSource != null) {
                cir.setReturnValue((Object)lightSource.get((Integer)cir.getReturnValue()));
            }
        }
    }

    @Pseudo
    @Mixin(targets={"dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources"})
    public static class EntityLightHandler {
        @Inject(method={"getLuminance"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private void aw2$getLuminance(Entity entity, CallbackInfoReturnable<Integer> cir) {
            SkinLightSource lightSource = ClientDynamicLightHandler.getLightSource(entity);
            if (lightSource != null) {
                cir.setReturnValue((Object)lightSource.get((Integer)cir.getReturnValue()));
            }
        }

        static {
            ClientDynamicLightHandler.init();
        }
    }

    @Pseudo
    @Mixin(targets={"dev.lambdaurora.lambdynlights.resource.item.ItemLightSources"})
    public static class ItemLightHandler {
        @Inject(method={"getLuminance"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private void aw2$getLuminance(ItemStack itemStack, boolean submergedInWater, CallbackInfoReturnable<Integer> cir) {
            SkinLightSource lightSource = ClientDynamicLightHandler.getLightSource(itemStack, submergedInWater);
            if (lightSource != null) {
                cir.setReturnValue((Object)lightSource.get((Integer)cir.getReturnValue()));
            }
        }
    }
}

