/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.core.math.ITransform3f;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryFace;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryVertex;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;

public class BakedLuminanceCalculator {
    private static final OpenRectangle3f DEFAULT = new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f);
    private static final Map<SkinPartType, OpenRectangle3f> BOXES = Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f));
        it.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f));
        it.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_WING, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_WING, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_PHALANX, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_PHALANX, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_TORSO, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_HAND, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_HAND, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_LEG, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_LEG, (Object)new OpenRectangle3f(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f));
    });

    public static int apply(List<BakedSkinPart> skinParts) {
        if (ModConfig.Client.skinDynamicLight >= 0) {
            return ModConfig.Client.skinDynamicLight;
        }
        OpenVector3f strength = new OpenVector3f();
        OpenPoseStack poseStack = new OpenPoseStack();
        for (BakedSkinPart skinPart : skinParts) {
            OpenRectangle3f fully = BOXES.getOrDefault(skinPart.type(), DEFAULT);
            OpenVector3f used = new OpenVector3f();
            BakedLuminanceCalculator.extract(skinPart, poseStack, rect -> {
                float tx = rect.depth() * rect.height();
                float ty = rect.width() * rect.depth();
                float tz = rect.width() * rect.height();
                used.add(tx, ty, tz);
            });
            float tx = used.x() / (fully.depth() * fully.height());
            float ty = used.y() / (fully.width() * fully.depth());
            float tz = used.z() / (fully.width() * fully.height());
            strength.add(tx, ty, tz);
        }
        float luminance = OpenMath.max(strength.x(), strength.y(), strength.z()) * 15.0f;
        return OpenMath.clamp(OpenMath.ceili(luminance), 0, 15);
    }

    private static void extract(BakedSkinPart part, OpenPoseStack poseStack, Consumer<OpenRectangle3f> applier) {
        part.quads().forEach((renderType, quad) -> {
            if (renderType.isEmissive()) {
                OpenVoxelShape shape = OpenVoxelShape.empty();
                quad.forEach((transform, faces) -> BakedLuminanceCalculator.merge(faces, transform, poseStack, shape));
                applier.accept(shape.bounds());
            }
        });
        for (BakedSkinPart child : part.children()) {
            poseStack.pushPose();
            child.transform().apply(poseStack);
            BakedLuminanceCalculator.extract(child, poseStack, applier);
            poseStack.popPose();
        }
    }

    private static void merge(List<BakedGeometryFace> faces, ITransform quadTransform, OpenPoseStack poseStack, OpenVoxelShape shape) {
        poseStack.pushPose();
        quadTransform.apply(poseStack);
        faces.forEach(face -> {
            ITransform3f faceTransform = face.transform();
            if (faceTransform != OpenTransform3f.IDENTITY) {
                poseStack.pushPose();
                faceTransform.apply(poseStack);
            }
            for (SkinGeometryVertex skinGeometryVertex : face.vertices()) {
                shape.add(skinGeometryVertex.position().transforming(poseStack.last().pose()));
            }
            if (faceTransform != OpenTransform3f.IDENTITY) {
                poseStack.popPose();
            }
        });
        poseStack.popPose();
    }
}

