/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderTypeImpl;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SkinRenderType
implements IRenderType {
    public static final IRenderType BLIT_COLOR = SkinRenderType._builder(SkinVertexFormat.BLIT_MASK).build("aw_blit_color");
    public static final IRenderType BLIT_MASK = SkinRenderType._builder(SkinVertexFormat.BLIT_MASK).writeMask(IRenderType.WriteMask.NONE).build("aw_blit_mask");
    public static final IRenderType BLIT_IMAGE = SkinRenderType._builder(SkinVertexFormat.GUI_IMAGE).build("aw_blit_image");
    public static final IRenderType GUI_COLOR = SkinRenderType._builder(SkinVertexFormat.GUI_COLOR).transparency(IRenderType.Transparency.DEFAULT).build("aw_gui_color");
    public static final IRenderType GUI_IMAGE = SkinRenderType._builder(SkinVertexFormat.GUI_IMAGE).transparency(IRenderType.Transparency.TRANSLUCENT).build("aw_gui_image");
    public static final IRenderType GUI_HIGHLIGHTED_TEXT = SkinRenderType._builder(SkinVertexFormat.GUI_HIGHLIGHTED_TEXT).transparency(IRenderType.Transparency.TRANSLUCENT).colorLogic(IRenderType.ColorLogic.OR_REVERSE).depthTest(IRenderType.DepthTest.NONE).build("aw_highlighted_text");
    public static final IRenderType IMAGE_MAGIC = SkinRenderType._texture(ModTextures.CIRCLE).writeMask(IRenderType.WriteMask.COLOR_WRITE).sortOnUpload().build("aw_image_magic");
    public static final IRenderType IMAGE_GUIDE = SkinRenderType._texture(ModTextures.GUIDES).polygonOffset(-1.0f, -10.0f).build("aw_image_guide");
    public static final IRenderType IMAGE_MARKER = SkinRenderType._texture2(ModTextures.MARKERS).polygonOffset(-1.0f, -10.0f).cull().build("aw_image_marker");
    public static final IRenderType HIGHLIGHTED_LINES = SkinRenderType._line(2.0f).depthTest(IRenderType.DepthTest.NONE).build("aw_lines_ndt");
    public static final IRenderType HIGHLIGHTED_ENTITY_LINES = SkinRenderType._entityHighlight(ModTextures.MANNEQUIN_HIGHLIGHT).build("aw_entity_lines");
    public static final IRenderType PLAYER_CUTOUT = SkinRenderType.entityCutout(ModTextures.MANNEQUIN_DEFAULT);
    public static final IRenderType PLAYER_CUTOUT_NO_CULL = SkinRenderType.entityCutoutNoCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final IRenderType PLAYER_TRANSLUCENT = SkinRenderType.entityTranslucentCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final IRenderType BLOCK_CUBE = SkinRenderType._block(ModTextures.BLOCK_CUBE).build("aw_block_cube");
    public static final IRenderType BLOCK_CUBE_GLASS = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderType.Transparency.TRANSLUCENT).sortOnUpload().build("aw_block_cube_glass");
    public static final IRenderType BLOCK_CUBE_GLASS_UNSORTED = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderType.Transparency.TRANSLUCENT).build("aw_block_cube_glass_unsorted");
    public static final IRenderType BLOCK_EARTH = SkinRenderType._builder(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT).texture(ModTextures.EARTH).transparency(IRenderType.Transparency.TRANSLUCENT).target(IRenderType.Target.TRANSLUCENT).cull().build("aw_block_earth");
    public static final IRenderType BLOCK_FACE_SOLID = SkinRenderType._blockFace(SkinVertexFormat.SKIN_BLOCK_FACE_SOLID).texture(ModTextures.CUBE).ordinal(200).build("aw_block_face_sold");
    public static final IRenderType BLOCK_FACE_LIGHTING = SkinRenderType._blockFace(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING).texture(ModTextures.LIGHTING_CUBE).ordinal(200).build("aw_block_face_lighting");
    public static final IRenderType BLOCK_FACE_TRANSLUCENT = SkinRenderType._blockFace(SkinVertexFormat.SKIN_BLOCK_FACE_TRANSLUCENT).texture(ModTextures.CUBE).transparency(IRenderType.Transparency.TRANSLUCENT).target(IRenderType.Target.TRANSLUCENT).ordinal(400).build("aw_block_face_translucent");
    public static final IRenderType BLOCK_FACE_LIGHTING_TRANSLUCENT = SkinRenderType._blockFace(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT).texture(ModTextures.LIGHTING_CUBE).transparency(IRenderType.Transparency.TRANSLUCENT).target(IRenderType.Target.TRANSLUCENT).ordinal(400).build("aw_block_face_translucent_lighting");
    private static final IRenderType LINES = SkinRenderType._line(1.0f).build("aw_lines");
    private static final IRenderType LINE_STRIP = SkinRenderType._builder(SkinVertexFormat.LINE_STRIP).lineWidth(1.0f).build("aw_line_strip");
    private static final ConcurrentHashMap<String, IRenderType> CUSTOM_FACE_VARIANTS = new ConcurrentHashMap();

    public static IRenderType by(SkinGeometryType geometryType) {
        if (geometryType == SkinGeometryTypes.BLOCK_GLASS) {
            return BLOCK_FACE_TRANSLUCENT;
        }
        if (geometryType == SkinGeometryTypes.BLOCK_GLASS_GLOWING) {
            return BLOCK_FACE_LIGHTING_TRANSLUCENT;
        }
        if (geometryType == SkinGeometryTypes.BLOCK_GLOWING) {
            return BLOCK_FACE_LIGHTING;
        }
        return BLOCK_FACE_SOLID;
    }

    public static IRenderType customFace(String name, SkinVertexFormat format, IResourceLocation texture, boolean isTranslucent, boolean isEmissive, boolean isCull) {
        String key = String.format("%s/%s", name, texture.path());
        return CUSTOM_FACE_VARIANTS.computeIfAbsent(key, it -> {
            IRenderTypeBuilder builder = SkinRenderType._customFace(format).texture(texture);
            if (isTranslucent) {
                builder = builder.transparency(IRenderType.Transparency.TRANSLUCENT).target(IRenderType.Target.TRANSLUCENT);
            }
            if (isCull) {
                builder = builder.cull();
            }
            builder = isTranslucent ? builder.ordinal(400) : builder.ordinal(200);
            return builder.build((String)it);
        });
    }

    public static IRenderType geometryFace(SkinGeometryType type, IResourceLocation texture, boolean isTranslucent, boolean isEmissive) {
        GeometryFaceBuilder builder = GeometryFaceBuilder.search(type, isTranslucent, isEmissive);
        if (builder != null) {
            return builder.build(texture);
        }
        return SkinRenderType.by(type);
    }

    public static IRenderType lines() {
        return LINES;
    }

    public static IRenderType lineStrip() {
        return LINE_STRIP;
    }

    public static IRenderType entityCutout(IResourceLocation texture) {
        return SkinRenderType._entity(SkinVertexFormat.ENTITY_CUTOUT, texture).cull().build("aw_player_solid");
    }

    public static IRenderType entityCutoutNoCull(IResourceLocation texture) {
        return SkinRenderType._entity(SkinVertexFormat.ENTITY_CUTOUT_NO_CULL, texture).build("aw_player_cutout");
    }

    public static IRenderType entityTranslucentCull(IResourceLocation texture) {
        return SkinRenderType._entity(SkinVertexFormat.ENTITY_TRANSLUCENT, texture).cull().transparency(IRenderType.Transparency.TRANSLUCENT).build("aw_player_translucent");
    }

    private static IRenderTypeBuilder _entity(SkinVertexFormat format, IResourceLocation texture) {
        return SkinRenderType._builder(format).texture(texture).polygonOffset(0.0f, 30.0f).overlay().lightmap().sortOnUpload().crumbling().outline();
    }

    private static IRenderTypeBuilder _entityHighlight(IResourceLocation texture) {
        return SkinRenderType._builder(SkinVertexFormat.ENTITY_ALPHA).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _blockFace(SkinVertexFormat format) {
        return SkinRenderType._builder(format).outline();
    }

    private static IRenderTypeBuilder _customFace(SkinVertexFormat format) {
        return SkinRenderType._builder(format).outline();
    }

    private static IRenderTypeBuilder _texture(IResourceLocation texture) {
        return SkinRenderType._builder(SkinVertexFormat.IMAGE).texture(texture).transparency(IRenderType.Transparency.TRANSLUCENT).target(IRenderType.Target.TRANSLUCENT);
    }

    private static IRenderTypeBuilder _texture2(IResourceLocation texture) {
        return SkinRenderType._builder(SkinVertexFormat.BLOCK_CUTOUT).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _block(IResourceLocation texture) {
        return SkinRenderType._builder(SkinVertexFormat.BLOCK).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _line(float lineWidth) {
        return SkinRenderType._builder(SkinVertexFormat.LINE).lineWidth(lineWidth).polygonOffset(0.0f, 10.0f);
    }

    private static IRenderTypeBuilder _builder(SkinVertexFormat format) {
        return AbstractRenderTypeImpl.builder(format);
    }

    private static class GeometryFaceBuilder {
        private static final List<GeometryFaceBuilder> BUILDERS = Collections.immutableList(it -> {
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_solid", SkinGeometryTypes.CUBE, SkinVertexFormat.SKIN_CUBE_FACE_SOLID, false, false, false));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_lighting", SkinGeometryTypes.CUBE, SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, false, true, false));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_translucent", SkinGeometryTypes.CUBE, SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, true, false, false));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_translucent_lighting", SkinGeometryTypes.CUBE, SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, true, true, false));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_solid_cull", SkinGeometryTypes.CUBE_CULL, SkinVertexFormat.SKIN_CUBE_FACE_SOLID, false, false, true));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_lighting_cull", SkinGeometryTypes.CUBE_CULL, SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, false, true, true));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_translucent_cull", SkinGeometryTypes.CUBE_CULL, SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, true, false, true));
            it.add((Object)new GeometryFaceBuilder("aw_cube_face_translucent_lighting_cull", SkinGeometryTypes.CUBE_CULL, SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, true, true, true));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_solid", SkinGeometryTypes.MESH, SkinVertexFormat.SKIN_MESH_FACE_SOLID, false, false, false));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_lighting", SkinGeometryTypes.MESH, SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, false, true, false));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_translucent", SkinGeometryTypes.MESH, SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, true, false, false));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_translucent_lighting", SkinGeometryTypes.MESH, SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, true, true, false));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_solid_cull", SkinGeometryTypes.MESH_CULL, SkinVertexFormat.SKIN_MESH_FACE_SOLID, false, false, true));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_lighting_cull", SkinGeometryTypes.MESH_CULL, SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, false, true, true));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_translucent_cull", SkinGeometryTypes.MESH_CULL, SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, true, false, true));
            it.add((Object)new GeometryFaceBuilder("aw_mesh_face_translucent_lighting_cull", SkinGeometryTypes.MESH_CULL, SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, true, true, true));
        });
        private final String name;
        private final SkinGeometryType type;
        private final SkinVertexFormat format;
        private final boolean isTranslucent;
        private final boolean isEmissive;
        private final boolean isCull;

        public GeometryFaceBuilder(String name, SkinGeometryType type, SkinVertexFormat format, boolean isTranslucent, boolean isEmissive, boolean isCull) {
            this.name = name;
            this.type = type;
            this.format = format;
            this.isTranslucent = isTranslucent;
            this.isEmissive = isEmissive;
            this.isCull = isCull;
        }

        public static GeometryFaceBuilder search(SkinGeometryType type, boolean isTranslucent, boolean isEmissive) {
            for (GeometryFaceBuilder it : BUILDERS) {
                if (!type.equals(it.type) || isTranslucent != it.isTranslucent || isEmissive != it.isEmissive) continue;
                return it;
            }
            return null;
        }

        public IRenderType build(IResourceLocation texture) {
            return SkinRenderType.customFace(this.name, this.format, texture, this.isTranslucent, this.isEmissive, this.isCull);
        }
    }
}

