/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.cache;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;

public final class AutoreleasePool<T extends Lifecycle> {
    private static final Collection<AutoreleasePool<?>> POOLS = new ConcurrentLinkedDeque();
    private final ThreadLocal<T> lifecycles;

    public AutoreleasePool(Supplier<T> supplier) {
        this.lifecycles = ThreadLocal.withInitial(supplier);
        POOLS.add(this);
    }

    public static void begin() {
        POOLS.forEach(it -> it.get().begin());
    }

    public static void end() {
        POOLS.forEach(it -> it.get().end());
    }

    public T get() {
        return (T)((Lifecycle)this.lifecycles.get());
    }

    public static interface Lifecycle {
        public void begin();

        public void end();
    }
}

