/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isSmall(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.isSmall();
        }
        return false;
    }

    public static float getScale(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.scale();
        }
        return 1.0f;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        Vec3 origin = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.m_43720_(), context.m_8083_());
        ItemStack itemStack = context.m_43722_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverLevel, rayTraceResult.m_82425_(), itemStack, MobSpawnType.SPAWN_EGG);
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            Vec3 clickedLocation = rayTraceResult.m_82450_();
            entity.m_19890_(clickedLocation.m_7096_(), clickedLocation.m_7098_(), clickedLocation.m_7094_(), 0.0f, 0.0f);
            entity.m_5618_(rayTraceResult.rotation());
            serverLevel.m_7967_((Entity)entity);
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11684_, SoundSource.BLOCKS, 0.75f, 0.8f);
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)serverLevel.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    public String m_5671_(ItemStack itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.m_5671_(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.m_5671_(itemStack) + ".big";
        }
        return super.m_5671_(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.of(itemStack);
        if (descriptor.name() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.name()));
        }
        if (descriptor.url() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.url()));
        }
    }
}

