/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExecuteAlertPacket
extends CustomPacket {
    private final Component title;
    private final Component message;
    private final Component confirm;
    private final CompoundTag icon;
    private final int type;

    public ExecuteAlertPacket(Component title, Component message, Component confirm, int type, CompoundTag nbt) {
        this.title = title;
        this.message = message;
        this.confirm = confirm;
        this.type = type;
        this.icon = nbt;
    }

    public ExecuteAlertPacket(IFriendlyByteBuf buffer) {
        this.title = buffer.readComponent();
        this.message = buffer.readComponent();
        this.confirm = buffer.readComponent();
        this.type = buffer.readInt();
        this.icon = buffer.readNbt();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeComponent(this.title);
        buffer.writeComponent(this.message);
        buffer.writeComponent(this.confirm);
        buffer.writeInt(this.type);
        buffer.writeNbt(this.icon);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        UserNotificationCenter.showAlertFromServer(this);
    }

    public Component title() {
        return this.title;
    }

    public Component message() {
        return this.message;
    }

    public Component confirm() {
        return this.confirm;
    }

    public CompoundTag icon() {
        return this.icon;
    }

    public int type() {
        return this.type;
    }
}

