/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentAnimation;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentCollider;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinSaveException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SkinDocumentExporter {
    private final SkinDocument document;
    private OpenItemTransforms itemTransforms;
    private final HashMap<String, Skin> skins = new HashMap();

    public SkinDocumentExporter(SkinDocument document) {
        this.document = document;
    }

    public Skin execute(Player player, GameProfile profile) throws TranslatableException {
        SkinType skinType = this.document.type().skinType();
        SkinSettings settings = new SkinSettings();
        SkinProperties properties = this.document.properties().copy();
        ArrayList<SkinPart> parts = this.convertToParts(this.document.root());
        ArrayList<SkinAnimation> animations = this.convertToAnimations(this.document.animations());
        if (parts.isEmpty()) {
            throw SkinSaveException.Type.NO_DATA.build("noting", new Object[0]);
        }
        if (skinType == SkinTypes.BLOCK) {
            HashMap<OpenVector3i, OpenRectangle3i> boxes = SkinDocumentCollider.generateCollisionBox(this.document.root());
            settings.setCollisionBox(Collections.compactMap(boxes.values(), OpenRectangle3f::new));
            if (properties.get(SkinProperty.BLOCK_BED).booleanValue() && properties.get(SkinProperty.BLOCK_SEAT).booleanValue()) {
                throw SkinSaveException.Type.BED_AND_SEAT.build("conflictBedSeat", new Object[0]);
            }
            if (properties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue() && !boxes.containsKey(OpenVector3i.ZERO)) {
                throw SkinSaveException.Type.INVALID_MULTIBLOCK.build("missingMainBlock", new Object[0]);
            }
        }
        properties.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
        if (profile.getId() != null) {
            properties.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        settings.setEditable(false);
        settings.setItemTransforms(this.itemTransforms);
        if (properties.get(SkinProperty.OVERRIDE_ENTITY_SIZE).booleanValue()) {
            Double width = properties.get(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH);
            Double height = properties.get(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT);
            Double eyeHeight = properties.get(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT);
            settings.setCollisionBox(Collections.newList(new OpenRectangle3f(0.0, eyeHeight, 0.0, width, height, width)));
        }
        properties.remove(SkinProperty.OVERRIDE_ENTITY_SIZE);
        properties.remove(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH);
        properties.remove(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT);
        properties.remove(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT);
        builder.version(25);
        builder.settings(settings);
        builder.properties(properties);
        builder.parts(parts);
        builder.animations(animations);
        builder.previewData(null);
        builder.blobs(null);
        return builder.build();
    }

    public void setItemTransforms(OpenItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
    }

    public OpenItemTransforms itemTransforms() {
        return this.itemTransforms;
    }

    private ArrayList<SkinPart> convertToParts(SkinDocumentNode parent) throws TranslatableException {
        ArrayList<SkinPart> allParts = new ArrayList<SkinPart>();
        for (SkinDocumentNode node : parent.children()) {
            if (!node.isEnabled()) continue;
            Skin skin = this.loadSkin(node);
            List<SkinPart> using = this.loadSkinParts(skin, node);
            OpenTransform3f transform = node.transform();
            ArrayList<SkinPart> parts = this.convertToParts(node);
            if (using == null && parts.isEmpty()) continue;
            if (using != null && node.type() == using.get(0).type() && parts.isEmpty() && transform.isIdentity()) {
                SkinPart part = using.get(0);
                SkinPart.Builder builder = new SkinPart.Builder(node.type());
                if (!node.isLocked()) {
                    builder.name(node.name());
                }
                builder.transform(part.transform());
                builder.geometries((SkinGeometrySet<?>)part.geometries());
                builder.markers(this.loadSkinMarkers(node));
                builder.properties(part.properties());
                SkinPart newPart = builder.build();
                part.children().forEach(newPart::addPart);
                allParts.add(newPart);
                continue;
            }
            SkinPart.Builder builder = new SkinPart.Builder(node.type());
            if (!node.isLocked()) {
                builder.name(node.name());
            }
            builder.transform(transform);
            builder.markers(this.loadSkinMarkers(node));
            builder.properties(SkinProperties.EMPTY);
            builder.blobs(null);
            SkinPart part = builder.build();
            if (using != null) {
                using.forEach(part::addPart);
            }
            parts.forEach(part::addPart);
            allParts.add(part);
        }
        return allParts;
    }

    private ArrayList<SkinAnimation> convertToAnimations(List<SkinDocumentAnimation> importedAnimations) throws TranslatableException {
        ArrayList<SkinAnimation> animations = new ArrayList<SkinAnimation>();
        if (importedAnimations == null || importedAnimations.isEmpty()) {
            return animations;
        }
        for (SkinDocumentAnimation importedAnimation : importedAnimations) {
            SkinAnimation animation = this.loadSkinAnimation(importedAnimation);
            if (animation == null) continue;
            animations.add(animation);
        }
        return animations;
    }

    @Nullable
    private List<SkinPart> loadSkinParts(Skin skin, SkinDocumentNode node) throws TranslatableException {
        List<SkinPart> parts;
        if (skin != null && !(parts = skin.parts()).isEmpty()) {
            return parts;
        }
        return null;
    }

    @Nullable
    private SkinAnimation loadSkinAnimation(SkinDocumentAnimation ref) throws TranslatableException {
        String name = ref.name();
        SkinDescriptor descriptor = ref.descriptor();
        if (name.isEmpty() || descriptor.isEmpty()) {
            return null;
        }
        Skin skin = this.loadSkin(name, descriptor);
        for (SkinAnimation animation : skin.animations()) {
            if (!animation.name().equals(ref.name())) continue;
            return animation;
        }
        return null;
    }

    @Nullable
    private Skin loadSkin(SkinDocumentNode node) throws TranslatableException {
        SkinDescriptor descriptor = node.skin();
        if (!descriptor.isEmpty()) {
            return this.loadSkin(node.name(), descriptor);
        }
        return null;
    }

    private Skin loadSkin(String source, SkinDescriptor descriptor) throws TranslatableException {
        String identifier = descriptor.identifier();
        Skin skin = this.skins.get(identifier);
        if (skin != null) {
            return skin;
        }
        skin = SkinLoader.getInstance().loadSkin(identifier);
        if (skin == null) {
            throw new TranslatableException("exception.armourers_workshop.load.notFoundNodePart", identifier, source);
        }
        this.skins.put(identifier, skin);
        return skin;
    }

    private List<SkinMarker> loadSkinMarkers(SkinDocumentNode node) {
        ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
        for (SkinDocumentNode child : node.children()) {
            if (!child.isLocator()) continue;
            int x = -OpenMath.floori(child.location().x());
            int y = -OpenMath.floori(child.location().y());
            int z = OpenMath.floori(child.location().z());
            SkinMarker marker = new SkinMarker((byte)x, (byte)y, (byte)z, 0);
            markers.add(marker);
        }
        return markers;
    }
}

