/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.math.OpenSize2f;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchObject;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;

public class BlockBenchTexture
extends BlockBenchObject {
    private final boolean particle;
    private final String renderMode;
    private final String source;
    private final OpenSize2f imageSize;
    private final OpenSize2f textureSize;
    private final int frameTime;
    private final String frameOrderType;
    private final String frameOrder;
    private final boolean frameInterpolate;

    public BlockBenchTexture(String uuid, String name, boolean particle, String renderMode, String source, OpenSize2f imageSize, OpenSize2f textureSize, int frameTime, String frameOrderType, String frameOrder, boolean frameInterpolate) {
        super(uuid, name);
        this.particle = particle;
        this.renderMode = renderMode;
        this.source = source;
        this.imageSize = imageSize;
        this.textureSize = textureSize;
        this.frameTime = frameTime;
        this.frameOrderType = frameOrderType;
        this.frameOrder = frameOrder;
        this.frameInterpolate = frameInterpolate;
    }

    public boolean isParticle() {
        return this.particle;
    }

    public String source() {
        return this.source;
    }

    public OpenSize2f imageSize() {
        return this.imageSize;
    }

    public OpenSize2f textureSize() {
        return this.textureSize;
    }

    public int frameTime() {
        return this.frameTime;
    }

    public boolean frameInterpolate() {
        return this.frameInterpolate;
    }

    public SkinTextureAnimation.Mode frameMode() {
        return switch (this.frameOrderType) {
            case "loop" -> SkinTextureAnimation.Mode.LOOP;
            case "backwards" -> SkinTextureAnimation.Mode.BACKWARDS;
            case "back_and_forth" -> SkinTextureAnimation.Mode.BACK_AND_FORTH;
            case "custom" -> {
                int[] frames = this._parseFrameSeq(this.frameOrder);
                if (frames.length >= 1) {
                    yield new SkinTextureAnimation.Mode(frames);
                }
                yield SkinTextureAnimation.Mode.LOOP;
            }
            default -> SkinTextureAnimation.Mode.LOOP;
        };
    }

    public SkinTextureProperties properties() {
        SkinTextureProperties properties = new SkinTextureProperties();
        properties.setEmissive(this.renderMode.equals("emissive"));
        return properties;
    }

    private int[] _parseFrameSeq(String input) {
        String[] parts = input.split("\\s+");
        ArrayList<Integer> values = new ArrayList<Integer>(parts.length);
        for (String part : parts) {
            try {
                int value = Integer.parseInt(part);
                values.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int[] frames = new int[values.size()];
        for (int i = 0; i < frames.length; ++i) {
            frames[i] = (Integer)values.get(i);
        }
        return frames;
    }

    protected static class Builder
    extends BlockBenchObject.Builder {
        private String renderMode = "default";
        private String source;
        private boolean particle = false;
        private int frameTime = 1;
        private String frameOrderType = "loop";
        private String frameOrder = "";
        private boolean frameInterpolate = false;
        private OpenSize2f imageSize;
        private OpenSize2f textureSize;

        protected Builder() {
        }

        public void renderMode(String renderMode) {
            this.renderMode = renderMode;
        }

        public void particle(boolean particle) {
            this.particle = particle;
        }

        public void source(String source) {
            this.source = source;
        }

        public void imageSize(OpenSize2f size) {
            this.imageSize = size;
        }

        public void textureSize(OpenSize2f size) {
            this.textureSize = size;
        }

        public void frameTime(int frameTime) {
            this.frameTime = frameTime;
        }

        public void frameOrderType(String frameOrderType) {
            this.frameOrderType = frameOrderType;
        }

        public void frameOrder(String frameOrder) {
            this.frameOrder = frameOrder;
        }

        public void frameInterpolate(boolean frameInterpolate) {
            this.frameInterpolate = frameInterpolate;
        }

        public BlockBenchTexture build() {
            return new BlockBenchTexture(this.uuid, this.name, this.particle, this.renderMode, this.source, this.imageSize, this.textureSize, this.frameTime, this.frameOrderType, this.frameOrder, this.frameInterpolate);
        }
    }
}

