/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SkinPaintScheme
implements IDataSerializable.Immutable {
    public static final SkinPaintScheme EMPTY = new SkinPaintScheme();
    public static final IDataCodec<SkinPaintScheme> CODEC = IDataCodec.COMPOUND_TAG.serializer(SkinPaintScheme::new);
    private final HashMap<SkinPaintType, SkinPaintColor> colors = new HashMap();
    private HashMap<SkinPaintType, SkinPaintColor> resolvedColors;
    private SkinPaintScheme reference;
    private OpenResourceLocation texture;
    private int hashCode;

    public SkinPaintScheme() {
    }

    public SkinPaintScheme(IDataSerializer serializer) {
        for (Map.Entry<SkinPaintType, IDataSerializerKey<SkinPaintColor>> entry : CodingKeys.KEYS.entrySet()) {
            SkinPaintColor value = serializer.read(entry.getValue());
            if (value == null) continue;
            this.colors.put(entry.getKey(), value);
        }
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        for (Map.Entry<SkinPaintType, IDataSerializerKey<SkinPaintColor>> entry : CodingKeys.KEYS.entrySet()) {
            SkinPaintColor value = this.colors.get(entry.getKey());
            if (value == null) continue;
            serializer.write(entry.getValue(), value);
        }
    }

    public SkinPaintScheme copy() {
        SkinPaintScheme scheme = new SkinPaintScheme();
        scheme.colors.putAll(this.colors);
        scheme.reference = this.reference;
        scheme.texture = this.texture;
        return scheme;
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.reference != null && !this.reference.isEmpty()) {
            return false;
        }
        if (this.texture != null) {
            return false;
        }
        return this.colors.isEmpty();
    }

    @Nullable
    public SkinPaintColor getColor(SkinPaintType paintType) {
        SkinPaintColor color = this.colors.get(paintType);
        if (color != null) {
            return color;
        }
        if (this.reference != null) {
            return this.reference.getColor(paintType);
        }
        return null;
    }

    public void setColor(SkinPaintType paintType, SkinPaintColor color) {
        this.colors.put(paintType, color);
        this.resolvedColors = null;
        this.hashCode = 0;
    }

    public SkinPaintColor getResolvedColor(SkinPaintType paintType) {
        if (this.resolvedColors == null) {
            this.resolvedColors = this.resolvedColors();
        }
        return this.resolvedColors.get(paintType);
    }

    public OpenResourceLocation texture() {
        return this.texture;
    }

    public void setTexture(OpenResourceLocation texture) {
        this.texture = texture;
    }

    public SkinPaintScheme reference() {
        if (this.reference != null) {
            return this.reference;
        }
        return EMPTY;
    }

    public void setReference(SkinPaintScheme reference) {
        if (reference != null && reference.isEmpty()) {
            reference = null;
        }
        if (!Objects.equals(this.reference, reference)) {
            this.reference = reference;
            this.resolvedColors = null;
            this.hashCode = 0;
        }
    }

    private HashMap<SkinPaintType, SkinPaintColor> resolvedColors() {
        HashMap<SkinPaintType, SkinPaintColor> resolvedColors = new HashMap<SkinPaintType, SkinPaintColor>();
        HashMap<SkinPaintType, ArrayList> dependencies = new HashMap<SkinPaintType, ArrayList>();
        if (this.reference != null) {
            resolvedColors.putAll(this.reference.resolvedColors());
        }
        Collections.concat(this.colors.entrySet(), this.reference().colors.entrySet()).forEach(e -> {
            SkinPaintType paintType = (SkinPaintType)e.getKey();
            SkinPaintColor color = (SkinPaintColor)e.getValue();
            if (color.paintType().dyeType() != null) {
                dependencies.computeIfAbsent(color.paintType(), k -> new ArrayList()).add(paintType);
            } else {
                resolvedColors.put(paintType, color);
            }
        });
        if (resolvedColors.isEmpty()) {
            return resolvedColors;
        }
        dependencies.forEach((key, value) -> this.find(dependencies.values(), v -> v.contains(key)).ifPresent(target -> {
            if (target != value) {
                target.addAll(value);
            }
            value.clear();
        }));
        dependencies.forEach((key, value) -> value.forEach(paintType -> resolvedColors.put((SkinPaintType)paintType, (SkinPaintColor)resolvedColors.get(key))));
        return resolvedColors;
    }

    private <T> Optional<T> find(Collection<T> values, Predicate<T> predicate) {
        for (T value : values) {
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinPaintScheme)) {
            return false;
        }
        SkinPaintScheme that = (SkinPaintScheme)o;
        return this.colors.equals(that.colors) && Objects.equals(this.texture, that.texture) && Objects.equals(this.reference, that.reference);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.colors, this.texture, this.reference);
            if (this.hashCode == 0) {
                this.hashCode ^= 0xFFFFFFFF;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return "[" + String.valueOf(this.resolvedColors()) + "]";
    }

    private static class CodingKeys {
        public static final Map<SkinPaintType, IDataSerializerKey<SkinPaintColor>> KEYS = Collections.immutableMap(it -> {
            for (SkinPaintType paintType : SkinPaintTypes.values()) {
                if (paintType == SkinPaintTypes.NONE) continue;
                String name = paintType.registryName().toString();
                IDataSerializerKey<Object> key = IDataSerializerKey.create(name, SkinPaintColor.CODEC, null);
                it.put((Object)paintType, key);
            }
        });

        private CodingKeys() {
        }
    }
}

