/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OpenNativeImage {
    private final NativeImage impl;

    private OpenNativeImage(NativeImage impl) {
        this.impl = impl;
    }

    public static OpenNativeImage of(NativeImage image) {
        if (image != null) {
            return new OpenNativeImage(image);
        }
        return null;
    }

    public static OpenNativeImage of(int textureId, int width, int height) {
        OpenNativeImage image = new OpenNativeImage(new NativeImage(width, height, true));
        image.impl.m_85045_(textureId, false);
        return image;
    }

    public int getPixel(int x, int y) {
        int color = this.impl.m_84985_(x, y);
        int red = color << 16 & 0xFF0000;
        int blue = color >> 16 & 0xFF;
        return color & 0xFF00FF00 | red | blue;
    }

    public void setPixel(int x, int y, int color) {
        int red = color >> 16 & 0xFF;
        int blue = color << 16 & 0xFF0000;
        this.impl.m_84988_(x, y, color & 0xFF00FF00 | red | blue);
    }

    public void copyFrom(OpenNativeImage image) {
        this.impl.m_85054_(image.impl);
    }

    public OpenNativeImage clone() {
        NativeImage newValue = new NativeImage(this.impl.m_85102_(), this.impl.m_84982_(), this.impl.m_85084_(), true);
        return new OpenNativeImage(newValue);
    }

    public int width() {
        return this.impl.m_84982_();
    }

    public int height() {
        return this.impl.m_85084_();
    }
}

