/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.data.DataPackBuilder;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class ModEntityProfiles {
    private static final ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> INSERT_HANDLERS = new ArrayList();
    private static final ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> REMOVE_HANDLERS = new ArrayList();
    private static final ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> UPDATE_HANDLERS = new ArrayList();
    private static final Map<IResourceLocation, EntityProfile> USING_PROFILES = new LinkedHashMap<IResourceLocation, EntityProfile>();
    private static final Map<IResourceLocation, EntityProfile> CUSTOM_PROFILES = new LinkedHashMap<IResourceLocation, EntityProfile>();
    private static final Map<IResourceLocation, EntityProfile> BUILTIN_PROFILES = new LinkedHashMap<IResourceLocation, EntityProfile>();
    private static final Map<IEntityTypeProvider<?>, EntityProfile> USING_ENTITIES = new LinkedHashMap();
    private static final Map<IEntityTypeProvider<?>, EntityProfile> CUSTOM_ENTITIES = new LinkedHashMap();
    private static final Map<IEntityTypeProvider<?>, EntityProfile> BUILTIN_ENTITIES = new LinkedHashMap();
    private static final Map<IEntityTypeProvider<?>, EntityProfile> SERVER_ENTITIES = new LinkedHashMap();

    public static void init() {
        DataPackManager.register(DataPackType.SERVER_DATA, "skin/profiles", SimpleLoader::custom, null, SimpleLoader::freezeCustom, 1);
        DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/profiles", SimpleLoader::builtin, null, SimpleLoader::freezeBuiltin, 1);
    }

    public static void addListener(BiConsumer<IEntityTypeProvider<?>, EntityProfile> changeHandler) {
        REMOVE_HANDLERS.add((entityType, entityProfile) -> changeHandler.accept((IEntityTypeProvider<?>)entityType, (EntityProfile)null));
        INSERT_HANDLERS.add(changeHandler);
        UPDATE_HANDLERS.add(changeHandler);
        USING_ENTITIES.forEach(changeHandler);
    }

    @Nullable
    public static <T extends Entity> EntityProfile getProfile(T entity) {
        return ModEntityProfiles.getProfile(entity.m_6095_());
    }

    @Nullable
    public static <T extends Entity> EntityProfile getProfile(EntityType<T> entityType) {
        for (Map.Entry<IEntityTypeProvider<?>, EntityProfile> entry : USING_ENTITIES.entrySet()) {
            if (!entityType.equals(entry.getKey().get())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static EntityProfile getProfile(IResourceLocation registryName) {
        return USING_PROFILES.get(registryName);
    }

    public static void setCustomProfiles(Map<IEntityTypeProvider<?>, EntityProfile> snapshot) {
        if (SERVER_ENTITIES.equals(snapshot)) {
            return;
        }
        ModLog.debug("apply entity profile changes from server", new Object[0]);
        SERVER_ENTITIES.clear();
        SERVER_ENTITIES.putAll(snapshot);
        SimpleLoader.freeze();
    }

    public static Map<IEntityTypeProvider<?>, EntityProfile> getCustomProfiles() {
        return CUSTOM_ENTITIES;
    }

    private static class SimpleLoader
    implements DataPackBuilder {
        private static final Map<IResourceLocation, SimpleBuilder> CUSTOM_PROFILE_BUILDERS = new LinkedHashMap<IResourceLocation, SimpleBuilder>();
        private static final Map<IResourceLocation, SimpleBuilder> BUILTIN_PROFILE_BUILDERS = new LinkedHashMap<IResourceLocation, SimpleBuilder>();
        private final SimpleBuilder builder;

        public SimpleLoader(SimpleBuilder builder) {
            this.builder = builder;
        }

        public static SimpleLoader builtin(IResourceLocation registryName) {
            return new SimpleLoader(BUILTIN_PROFILE_BUILDERS.computeIfAbsent(registryName, SimpleBuilder::builtin));
        }

        public static SimpleLoader custom(IResourceLocation registryName) {
            return new SimpleLoader(CUSTOM_PROFILE_BUILDERS.computeIfAbsent(registryName, SimpleBuilder::custom));
        }

        @Override
        public void append(IODataObject object, IResourceLocation location) {
            if (object.get("replace").boolValue()) {
                this.builder.isLocked = false;
                this.builder.supports.clear();
                this.builder.transformers.clear();
                this.builder.entities.clear();
            }
            object.get("locked").ifPresent(o -> {
                this.builder.isLocked = o.boolValue();
            });
            object.get("slots").entrySet().forEach(it -> {
                SkinSlotType type = SkinSlotType.byName((String)it.getKey());
                String name = ((IODataObject)it.getValue()).stringValue();
                if (type != null) {
                    this.builder.supports.put(type, name);
                }
            });
            object.get("transformers").allValues().forEach(o -> this.builder.transformers.add(OpenResourceLocation.parse(o.stringValue())));
            object.get("entities").allValues().forEach(o -> this.builder.entities.add(IEntityTypeProvider.of(o.stringValue())));
        }

        @Override
        public void build() {
        }

        private static void freezeCustom() {
            LinkedHashMap<IEntityTypeProvider, EntityProfile> newEntities = new LinkedHashMap<IEntityTypeProvider, EntityProfile>();
            CUSTOM_ENTITIES.clear();
            CUSTOM_PROFILE_BUILDERS.forEach((key, builder) -> {
                EntityProfile profile = builder.build();
                builder.entities.forEach(entityType -> newEntities.put((IEntityTypeProvider)entityType, profile));
            });
            CUSTOM_PROFILE_BUILDERS.clear();
            LinkedHashMap usedProfiles = new LinkedHashMap();
            newEntities.forEach((entityType, profile) -> {
                EntityProfile oldProfile = BUILTIN_ENTITIES.get(entityType);
                if (oldProfile != null && EntityProfile.same(oldProfile, profile)) {
                    return;
                }
                CUSTOM_ENTITIES.put((IEntityTypeProvider<?>)entityType, (EntityProfile)profile);
                usedProfiles.put(profile.registryName(), profile);
            });
            SimpleLoader.difference(CUSTOM_PROFILES, usedProfiles, (registryName, entityProfile) -> {
                CUSTOM_PROFILES.remove(registryName);
                ModLog.debug("Unregistering Entity Profile '{}'", registryName);
            }, (registryName, entityProfile) -> {
                ModLog.debug("Registering Entity Profile '{}'", registryName);
                CUSTOM_PROFILES.put((IResourceLocation)registryName, (EntityProfile)entityProfile);
            }, null);
            SimpleLoader.freeze();
        }

        private static void freezeBuiltin() {
            LinkedHashMap newProfiles = new LinkedHashMap();
            BUILTIN_ENTITIES.clear();
            BUILTIN_PROFILE_BUILDERS.forEach((key, builder) -> {
                EntityProfile profile = builder.build();
                newProfiles.put(builder.registryName, profile);
                builder.entities.forEach(entityType -> BUILTIN_ENTITIES.put((IEntityTypeProvider<?>)entityType, profile));
            });
            BUILTIN_PROFILE_BUILDERS.clear();
            SimpleLoader.difference(BUILTIN_PROFILES, newProfiles, (registryName, entityProfile) -> {
                BUILTIN_PROFILES.remove(registryName);
                ModLog.debug("Unregistering Entity Profile '{}'", registryName);
            }, (registryName, entityProfile) -> {
                ModLog.debug("Registering Entity Profile '{}'", registryName);
                BUILTIN_PROFILES.put((IResourceLocation)registryName, (EntityProfile)entityProfile);
            }, null);
            SimpleLoader.freeze();
        }

        private static void freeze() {
            LinkedHashMap entities = new LinkedHashMap();
            entities.putAll(BUILTIN_ENTITIES);
            entities.putAll(CUSTOM_ENTITIES);
            entities.putAll(SERVER_ENTITIES);
            SimpleLoader.difference(USING_ENTITIES, entities, (entityType, entityProfile) -> {
                USING_ENTITIES.remove(entityType);
                REMOVE_HANDLERS.forEach((Consumer<BiConsumer<IEntityTypeProvider<?>, EntityProfile>>)((Consumer<BiConsumer>)handler -> handler.accept(entityType, entityProfile)));
            }, (entityType, entityProfile) -> {
                USING_ENTITIES.put((IEntityTypeProvider<?>)entityType, (EntityProfile)entityProfile);
                INSERT_HANDLERS.forEach((Consumer<BiConsumer<IEntityTypeProvider<?>, EntityProfile>>)((Consumer<BiConsumer>)handler -> handler.accept(entityType, entityProfile)));
            }, (entityType, entityProfile) -> {
                USING_ENTITIES.put((IEntityTypeProvider<?>)entityType, (EntityProfile)entityProfile);
                UPDATE_HANDLERS.forEach((Consumer<BiConsumer<IEntityTypeProvider<?>, EntityProfile>>)((Consumer<BiConsumer>)handler -> handler.accept(entityType, entityProfile)));
            });
            USING_PROFILES.clear();
            entities.values().forEach(profile -> USING_PROFILES.put(profile.registryName(), (EntityProfile)profile));
        }

        private static <K, V> void difference(Map<K, V> oldValue, Map<K, V> newValue, BiConsumer<K, V> removeHandler, BiConsumer<K, V> insertHandler, BiConsumer<K, V> updateHandler) {
            LinkedHashMap removedEntities = new LinkedHashMap(oldValue);
            newValue.forEach((key, value) -> {
                Object oldEntry = removedEntities.remove(key);
                if (oldEntry == null) {
                    if (insertHandler != null) {
                        insertHandler.accept(key, value);
                    }
                } else if (oldEntry != value && updateHandler != null) {
                    updateHandler.accept(key, value);
                }
            });
            if (removeHandler != null) {
                removedEntities.forEach(removeHandler);
            }
        }
    }

    private static class SimpleBuilder {
        private final IResourceLocation registryName;
        private final List<IEntityTypeProvider<?>> entities = new ArrayList();
        private final List<IResourceLocation> transformers = new ArrayList<IResourceLocation>();
        private final Map<SkinSlotType, String> supports = new LinkedHashMap<SkinSlotType, String>();
        private boolean isLocked = false;

        public SimpleBuilder(IResourceLocation registryName) {
            this.registryName = registryName;
        }

        public static SimpleBuilder builtin(IResourceLocation location) {
            String path = FileUtils.getRegistryName(location.path(), "skin/profiles/");
            return new SimpleBuilder(location.withPath("builtin/" + path));
        }

        public static SimpleBuilder custom(IResourceLocation location) {
            String path = FileUtils.getRegistryName(location.path(), "skin/profiles/");
            return new SimpleBuilder(location.withPath(path));
        }

        public EntityProfile build() {
            return new EntityProfile(this.registryName, this.supports, this.transformers, this.isLocked);
        }
    }
}

