/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.world.entity.player.Player;

public class SkinLibrarySetting
implements IDataSerializable.Immutable {
    public static final SkinLibrarySetting DEFAULT = new SkinLibrarySetting();
    public static final IDataCodec<SkinLibrarySetting> CODEC = IDataCodec.COMPOUND_TAG.serializer(SkinLibrarySetting::new);
    private final int flags;
    private final String publicKey;

    public SkinLibrarySetting() {
        this.flags = 15;
        this.publicKey = null;
    }

    public SkinLibrarySetting(Player player) {
        int flags = 0;
        SkinLibraryManager.Server manager = SkinLibraryManager.getServer();
        if (manager.shouldUploadFile(player)) {
            flags |= 1;
        }
        if (manager.shouldDownloadFile(player)) {
            flags |= 2;
        }
        if (manager.shouldMaintenanceFile(player)) {
            flags |= 4;
        }
        this.flags = flags;
        this.publicKey = manager.publicKey();
    }

    public SkinLibrarySetting(IDataSerializer serializer) {
        this.flags = serializer.read(CodingKeys.FLAGS);
        this.publicKey = serializer.read(CodingKeys.PUBLIC_KEY);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.FLAGS, this.flags);
        serializer.write(CodingKeys.PUBLIC_KEY, this.publicKey);
    }

    public boolean allowsUpload() {
        return (this.flags & 1) != 0;
    }

    public boolean allowsDownload() {
        return (this.flags & 2) != 0;
    }

    public boolean allowsMaintenance() {
        return (this.flags & 4) != 0;
    }

    public String publicKey() {
        return this.publicKey;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Integer> FLAGS = IDataSerializerKey.create("Flags", IDataCodec.INT, 0);
        public static final IDataSerializerKey<String> PUBLIC_KEY = IDataSerializerKey.create("PublicKey", IDataCodec.STRING, null);

        private CodingKeys() {
        }
    }
}

