/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.utils.render.SkyblockerRenderPipelines;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import org.slf4j.Logger;

public class IrisCompatibility {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean IRIS_ENABLED = FabricLoader.getInstance().isModLoaded("iris");
    private static final String IRIS_API_CLASS = "net.irisshaders.iris.api.v0.IrisApi";
    private static final String IRIS_PROGRAM_CLASS = "net.irisshaders.iris.api.v0.IrisProgram";
    private static final MethodHandle GET_IRIS_API = IrisCompatibility.getIrisApiHandle();
    private static final MethodHandle REGISTER_PIPELINE = IrisCompatibility.getRegisterPipelineHandle();
    private static final MethodHandle GET_IRIS_PROGRAM = IrisCompatibility.getIrisProgramHandle();

    public static void assignPipelines() {
        if (IRIS_ENABLED) {
            IrisCompatibility.assignPipeline(class_10799.field_56837, "BASIC");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.FILLED_THROUGH_WALLS, "BASIC");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.LINES_THROUGH_WALLS, "LINES");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.QUADS_THROUGH_WALLS, "BASIC");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.TEXTURE, "TEXTURED");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.TEXTURE_THROUGH_WALLS, "TEXTURED");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.CYLINDER, "BASIC");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.CIRCLE, "BASIC");
            IrisCompatibility.assignPipeline(SkyblockerRenderPipelines.CIRCLE_LINES, "BASIC");
        }
    }

    private static void assignPipeline(RenderPipeline pipeline, String irisProgramName) {
        try {
            Objects.requireNonNull(GET_IRIS_API, "Iris API handle must be present to assign a pipeline.");
            Objects.requireNonNull(REGISTER_PIPELINE, "Iris register pipeline handle must be present to assign a pipeline.");
            Objects.requireNonNull(GET_IRIS_PROGRAM, "Iris Program handle must be present to assign a pipeline.");
            REGISTER_PIPELINE.invoke(GET_IRIS_API.invoke(), pipeline, GET_IRIS_PROGRAM.invoke(irisProgramName));
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable e) {
            LOGGER.error("[Skyblocker Iris Compatibility] Failed to assign pipeline {} to {}.", new Object[]{pipeline.getLocation(), irisProgramName, e});
        }
    }

    private static MethodHandle getIrisApiHandle() {
        try {
            Class<?> irisApiClass = Class.forName(IRIS_API_CLASS);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType type = MethodType.methodType(irisApiClass);
            return lookup.findStatic(irisApiClass, "getInstance", type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle getRegisterPipelineHandle() {
        try {
            Class<?> irisApiClass = Class.forName(IRIS_API_CLASS);
            Class<?> irisProgramClass = Class.forName(IRIS_PROGRAM_CLASS);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType type = MethodType.methodType(Void.TYPE, RenderPipeline.class, irisProgramClass);
            return lookup.findVirtual(irisApiClass, "assignPipeline", type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle getIrisProgramHandle() {
        try {
            Class<?> irisProgramClass = Class.forName(IRIS_PROGRAM_CLASS);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType type = MethodType.methodType(Enum.class, Class.class, String.class);
            MethodHandle enumValueOf = lookup.findStatic(Enum.class, "valueOf", type);
            return MethodHandles.insertArguments(enumValueOf, 0, irisProgramClass);
        }
        catch (Exception e) {
            return null;
        }
    }
}

