/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.events;

import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

public class DungeonEvents {
    public static final Event<DungeonLoaded> DUNGEON_LOADED = EventFactory.createArrayBacked(DungeonLoaded.class, callbacks -> () -> {
        for (DungeonLoaded callback : callbacks) {
            callback.onDungeonLoaded();
        }
    });
    public static final Event<DungeonStarted> DUNGEON_STARTED = EventFactory.createArrayBacked(DungeonStarted.class, callbacks -> () -> {
        for (DungeonStarted callback : callbacks) {
            callback.onDungeonStarted();
        }
    });
    public static final Event<RoomMatched> PUZZLE_MATCHED = EventFactory.createArrayBacked(RoomMatched.class, callbacks -> room -> {
        for (RoomMatched callback : callbacks) {
            callback.onRoomMatched(room);
        }
    });
    public static final Event<RoomMatched> ROOM_MATCHED = EventFactory.createArrayBacked(RoomMatched.class, callbacks -> room -> {
        for (RoomMatched callback : callbacks) {
            callback.onRoomMatched(room);
        }
        if (room.getType() == Room.Type.PUZZLE) {
            ((RoomMatched)PUZZLE_MATCHED.invoker()).onRoomMatched(room);
        }
    });

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface RoomMatched {
        public void onRoomMatched(Room var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DungeonStarted {
        public void onDungeonStarted();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DungeonLoaded {
        public void onDungeonLoaded();
    }
}

