/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.azureaaron.hmapi.data.rank.PackageRank;
import net.azureaaron.hmapi.data.rank.RankType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarpAutocomplete {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("warp_autocomplete.json");
    private static final Logger LOGGER = LoggerFactory.getLogger(WarpAutocomplete.class);
    private static final Codec<Object2BooleanMap<String>> MAP_CODEC = CodecUtils.object2BooleanMapCodec(Codec.STRING);
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> commandNode;

    @Init
    public static void init() {
        CompletableFuture.supplyAsync(() -> {
            try {
                String warps = Http.sendGetRequest("https://hysky.de/api/locations");
                return (Object2BooleanMap)MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)warps)).getOrThrow();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to download warps list", (Throwable)e);
                return Object2BooleanMaps.emptyMap();
            }
        }).thenAccept(warps -> {
            if (warps.isEmpty()) {
                WarpAutocomplete.getWarpsFromFile();
            } else {
                CompletableFuture.runAsync(() -> {
                    Optional result = MAP_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, warps).result();
                    if (result.isEmpty()) {
                        return;
                    }
                    JsonElement warpsJson = (JsonElement)result.get();
                    try (BufferedWriter writer = Files.newBufferedWriter(FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
                        SkyblockerMod.GSON.toJson(warpsJson, (Appendable)writer);
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Failed to save warps auto complete", (Throwable)e);
                    }
                });
                WarpAutocomplete.createCommandNode((Object2BooleanMap<String>)warps);
            }
        });
    }

    private static void getWarpsFromFile() {
        CompletableFuture.supplyAsync(() -> {
            JsonObject object;
            try (BufferedReader reader = Files.newBufferedReader(FILE);){
                object = (JsonObject)SkyblockerMod.GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (NoSuchFileException e) {
                return Object2BooleanMaps.emptyMap();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to read warp autocomplete file", (Throwable)e);
                return Object2BooleanMaps.emptyMap();
            }
            return MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).result().orElse(Object2BooleanMaps.emptyMap());
        }).thenAccept(WarpAutocomplete::createCommandNode);
    }

    private static void createCommandNode(Object2BooleanMap<String> warps) {
        commandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"warp").requires(fabricClientCommandSource -> Utils.isOnSkyblock())).then((ArgumentBuilder)ClientCommandManager.argument((String)"destination", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9264(WarpAutocomplete.getEligibleWarps(warps), (SuggestionsBuilder)builder)))).build();
    }

    private static Stream<String> getEligibleWarps(Object2BooleanMap<String> warps) {
        return warps.object2BooleanEntrySet().stream().filter(WarpAutocomplete::shouldShowWarp).map(Map.Entry::getKey);
    }

    private static boolean shouldShowWarp(Object2BooleanMap.Entry<String> entry) {
        return !entry.getBooleanValue() || Utils.isOnBingo() || RankType.compare((RankType)Utils.getRank(), (RankType)PackageRank.MVP_PLUS) >= 0;
    }
}

