/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.bazaar;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.jetbrains.annotations.Nullable;

public class BazaarOrderTracker
extends SimpleTooltipAdder {
    private static final String BAZAAR_HEAD_TEXTURE = "ewogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJpZCIgOiAiYmE0ODUzODFjNzI5NDhiY2E0NzY1NjJjNzRlZmE0NTkiLAogICAgICAidHlwZSIgOiAiU0tJTiIsCiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzIzMmUzODIwODk3NDI5MTU3NjE5YjBlZTA5OWZlYzA2MjhmNjAyZmZmMTJiNjk1ZGU1NGFlZjExZDkyM2FkNyIsCiAgICAgICJwcm9maWxlSWQiIDogIjdkYTJhYjNhOTNjYTQ4ZWU4MzA0OGFmYzNiODBlNjhlIiwKICAgICAgInRleHR1cmVJZCIgOiAiYzIzMmUzODIwODk3NDI5MTU3NjE5YjBlZTA5OWZlYzA2MjhmNjAyZmZmMTJiNjk1ZGU1NGFlZjExZDkyM2FkNyIKICAgIH0KICB9LAogICJza2luIiA6IHsKICAgICJpZCIgOiAiYmE0ODUzODFjNzI5NDhiY2E0NzY1NjJjNzRlZmE0NTkiLAogICAgInR5cGUiIDogIlNLSU4iLAogICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9jMjMyZTM4MjA4OTc0MjkxNTc2MTliMGVlMDk5ZmVjMDYyOGY2MDJmZmYxMmI2OTVkZTU0YWVmMTFkOTIzYWQ3IiwKICAgICJwcm9maWxlSWQiIDogIjdkYTJhYjNhOTNjYTQ4ZWU4MzA0OGFmYzNiODBlNjhlIiwKICAgICJ0ZXh0dXJlSWQiIDogImMyMzJlMzgyMDg5NzQyOTE1NzYxOWIwZWUwOTlmZWMwNjI4ZjYwMmZmZjEyYjY5NWRlNTRhZWYxMWQ5MjNhZDciCiAgfSwKICAiY2FwZSIgOiBudWxsCn0=";
    private static final Pattern ORDER_AMOUNT_PATTERN = Pattern.compile("(?:Order|Offer) amount: ([0-9,]+)x");
    private static final Pattern UNIT_PRICE_PATTERN = Pattern.compile("Price per unit: ([0-9,.]+) coins");
    private static final String CREATE_BUY_ORDER_TEXT = "Create Buy Order";
    private static final String CREATE_SELL_OFFER_TEXT = "Create Sell Offer";
    private static final Pattern ORDER_PATTERN = Pattern.compile("- ([0-9,.]+) coins? each \\| ([0-9,]+)x (in|from) ([0-9,]+) (order|offer)s?");
    public static final BazaarOrderTracker INSTANCE = new BazaarOrderTracker();
    private final Int2ObjectMap<Order> orders = new Int2ObjectOpenHashMap();

    private BazaarOrderTracker() {
        super(".* \u279c .*", 0);
    }

    void clearOrders() {
        this.orders.clear();
    }

    void processOrder(class_1799 stack, int slotId) {
        List<Matcher> matchers = ItemUtils.getLoreLineIfMatch(stack, UNIT_PRICE_PATTERN, ORDER_AMOUNT_PATTERN);
        if (matchers.size() < 2) {
            return;
        }
        String skyblockId = stack.getSkyblockId();
        double unitPrice = Double.parseDouble(matchers.get(0).group(1).replace(",", ""));
        int amount = Integer.parseInt(matchers.get(1).group(1).replace(",", ""));
        this.orders.put(slotId, (Object)new Order(skyblockId, unitPrice, amount, slotId < 18));
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (stack.method_31574(class_1802.field_8204) && CREATE_BUY_ORDER_TEXT.equals(stack.method_7964().getString())) {
            this.addOrderMarker(lines, false);
        } else if (stack.method_31574(class_1802.field_8895) && CREATE_SELL_OFFER_TEXT.equals(stack.method_7964().getString())) {
            this.addOrderMarker(lines, true);
        }
    }

    private void addOrderMarker(List<class_2561> lines, boolean sell) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 screen = (class_476)class_4372;
        String skyblockId = ((class_1735)((class_1707)screen.method_17577()).field_7761.get(13)).method_7677().getSkyblockId();
        SequencedCollection<Order> yourOrders = this.orders.values().stream().filter(o -> o.sell() == sell).filter(o -> o.skyblockId().equals(skyblockId)).sorted(Comparator.comparingDouble(Order::unitPrice)).toList();
        if (yourOrders.isEmpty()) {
            return;
        }
        if (!sell) {
            yourOrders = yourOrders.reversed();
        }
        int yourOrdersIndex = 0;
        for (int i = 0; i < lines.size() && yourOrdersIndex < yourOrders.size(); ++i) {
            class_2561 line = lines.get(i);
            Matcher matcher = ORDER_PATTERN.matcher(line.getString());
            if (!matcher.matches()) continue;
            double unitPrice = Double.parseDouble(matcher.group(1).replace(",", ""));
            while (yourOrdersIndex < yourOrders.size() && (sell ? ((Order)yourOrders.get(yourOrdersIndex)).unitPrice() < unitPrice : ((Order)yourOrders.get(yourOrdersIndex)).unitPrice() > unitPrice)) {
                ++yourOrdersIndex;
            }
            int yourOrdersCount = 0;
            int yourOrdersAmount = 0;
            while (yourOrdersIndex < yourOrders.size() && ((Order)yourOrders.get(yourOrdersIndex)).unitPrice() == unitPrice) {
                ++yourOrdersCount;
                yourOrdersAmount += ((Order)yourOrders.get(yourOrdersIndex)).amount();
                ++yourOrdersIndex;
            }
            if (yourOrdersCount == 0) continue;
            lines.add(++i, (class_2561)class_2561.method_43470((String)"  - ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"skyblocker.config.helpers.bazaar.orderTrackerTooltip", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(yourOrdersAmount)).method_27692(class_124.field_1060), class_2561.method_43470((String)String.valueOf(yourOrdersCount)).method_27692(class_124.field_1068)}).method_27692(class_124.field_1080)));
        }
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.bazaar.enableOrderTracker;
    }

    private record Order(String skyblockId, double unitPrice, int amount, boolean sell) {
    }
}

