/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.crimson.kuudra;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.CrimsonIsleConfig;
import de.hysky.skyblocker.skyblock.crimson.kuudra.Kuudra;
import de.hysky.skyblocker.skyblock.crimson.kuudra.KuudraPhase;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1570;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;

public class KuudraWaypoints {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float[] SUPPLIES_COLOR = new float[]{1.0f, 0.0f, 0.0f};
    private static final float[] PEARL_COLOR = new float[]{0.22352941f, 0.45882353f, 0.49019608f};
    private static final float[] SAFE_SPOT_COLOR = new float[]{1.0f, 0.33333334f, 1.0f};
    private static final Supplier<Waypoint.Type> SUPPLIES_AND_FUEL_TYPE = () -> SkyblockerConfigManager.get().crimsonIsle.kuudra.suppliesAndFuelWaypointType;
    private static final ObjectArrayList<Waypoint> SAFE_SPOT_WAYPOINTS = new ObjectArrayList();
    private static final ObjectArrayList<Waypoint> PEARL_WAYPOINTS = new ObjectArrayList();
    private static final Function<float[], Codec<List<Waypoint>>> CODEC = cc -> PosUtils.ALT_BLOCK_POS_CODEC.xmap(pos -> new Waypoint((class_2338)pos, () -> Waypoint.Type.HIGHLIGHT, (float[])cc, false), waypoint -> waypoint.pos).listOf();
    private static ObjectArrayList<Waypoint> supplyWaypoints = ObjectArrayList.of();
    private static ObjectArrayList<Waypoint> ballistaBuildWaypoints = ObjectArrayList.of();
    private static ObjectArrayList<Waypoint> fuelWaypoints = ObjectArrayList.of();
    private static boolean loaded;

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(KuudraWaypoints::extractRendering);
        ClientLifecycleEvents.CLIENT_STARTED.register(KuudraWaypoints::load);
        Scheduler.INSTANCE.scheduleCyclic(KuudraWaypoints::tick, 20);
    }

    private static void load(class_310 client) {
        CompletableFuture<Void> safeSpots = KuudraWaypoints.loadWaypoints(client, SkyblockerMod.id("crimson/kuudra/safe_spot_waypoints.json"), SAFE_SPOT_WAYPOINTS, SAFE_SPOT_COLOR);
        CompletableFuture<Void> pearls = KuudraWaypoints.loadWaypoints(client, SkyblockerMod.id("crimson/kuudra/pearl_waypoints.json"), PEARL_WAYPOINTS, PEARL_COLOR);
        CompletableFuture.allOf(safeSpots, pearls).whenComplete((_result, _throwable) -> {
            loaded = true;
        });
    }

    private static CompletableFuture<Void> loadWaypoints(class_310 client, class_2960 file, ObjectArrayList<Waypoint> list, float[] colorComponents) {
        return CompletableFuture.supplyAsync(() -> {
            List list;
            block8: {
                BufferedReader reader = client.method_1478().openAsReader(file);
                try {
                    list = (List)CODEC.apply(colorComponents).parse((DynamicOps)JsonOps.INSTANCE, (Object)KuudraWaypoints.getWaypoints(reader)).getOrThrow();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker Kuudra Waypoints] Failed to load kuudra waypoints from: {}", (Object)file, (Object)e);
                        return List.of();
                    }
                }
                reader.close();
            }
            return list;
        }).thenAccept(arg_0 -> list.addAll(arg_0));
    }

    private static JsonElement getWaypoints(BufferedReader reader) {
        return JsonParser.parseReader((Reader)reader).getAsJsonObject().getAsJsonArray("waypoints");
    }

    private static void tick() {
        class_310 client = class_310.method_1551();
        CrimsonIsleConfig.Kuudra config = SkyblockerConfigManager.get().crimsonIsle.kuudra;
        if (Utils.isInKuudra() && (config.supplyWaypoints || config.fuelWaypoints || config.ballistaBuildWaypoints) && client.field_1724 != null) {
            class_238 searchBox = client.field_1724.method_5829().method_1014(500.0);
            ObjectArrayList supplies = new ObjectArrayList();
            ObjectArrayList fuelCells = new ObjectArrayList();
            if ((config.supplyWaypoints || config.fuelWaypoints) && client.field_1687 != null) {
                List giants = client.field_1687.method_8390(class_1570.class, searchBox, giant -> giant.method_23318() < 67.0);
                for (class_1570 giant2 : giants) {
                    double yawOffset = giant2.method_36454() + 115.0f;
                    double x = giant2.method_23317() + 4.5 * Math.cos(yawOffset * 0.01745329238474369);
                    double y = 75.0;
                    double z = giant2.method_23321() + 4.5 * Math.sin(yawOffset * 0.01745329238474369);
                    Waypoint waypoint = new Waypoint(class_2338.method_49637((double)x, (double)y, (double)z), SUPPLIES_AND_FUEL_TYPE, SUPPLIES_COLOR, false);
                    if (Objects.requireNonNull(Kuudra.phase) == KuudraPhase.DPS) {
                        fuelCells.add((Object)waypoint);
                        continue;
                    }
                    supplies.add((Object)waypoint);
                }
            }
            ObjectArrayList ballistaBuildSpots = new ObjectArrayList();
            if (config.ballistaBuildWaypoints && client.field_1687 != null) {
                List armorStands = client.field_1687.method_8390(class_1531.class, searchBox, class_1297::method_16914);
                for (class_1531 armorStand : armorStands) {
                    String name = armorStand.method_5477().getString();
                    if (!config.ballistaBuildWaypoints || !name.contains("SNEAK + PUNCH")) continue;
                    ballistaBuildSpots.add((Object)new Waypoint(armorStand.method_24515(), () -> Waypoint.Type.WAYPOINT, SUPPLIES_COLOR, false));
                }
            }
            supplyWaypoints = supplies;
            ballistaBuildWaypoints = ballistaBuildSpots;
            fuelWaypoints = fuelCells;
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        CrimsonIsleConfig.Kuudra config = SkyblockerConfigManager.get().crimsonIsle.kuudra;
        if (Utils.isInKuudra() && loaded) {
            if (config.supplyWaypoints) {
                for (Waypoint waypoint : supplyWaypoints) {
                    waypoint.extractRendering(collector);
                }
            }
            if (config.ballistaBuildWaypoints) {
                for (Waypoint waypoint : ballistaBuildWaypoints) {
                    waypoint.extractRendering(collector);
                }
            }
            if (config.fuelWaypoints) {
                for (Waypoint waypoint : fuelWaypoints) {
                    waypoint.extractRendering(collector);
                }
            }
            if (config.safeSpotWaypoints) {
                for (Waypoint waypoint : SAFE_SPOT_WAYPOINTS) {
                    waypoint.extractRendering(collector);
                }
            }
            if (config.pearlWaypoints) {
                for (Waypoint waypoint : PEARL_WAYPOINTS) {
                    waypoint.extractRendering(collector);
                }
            }
        }
    }
}

