/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DungeonMapLabels {
    private static final Object2ObjectOpenHashMap<String, RoomLabel> LABELS = new Object2ObjectOpenHashMap();
    private static final float LABEL_SCALE = 0.55f;
    private static final float MAX_WIDTH_SCALAR = 1.5f;

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((_n, _p, _c) -> DungeonMapLabels.clearLabels());
        DungeonEvents.ROOM_MATCHED.register(DungeonMapLabels::onRoomMatched);
        Scheduler.INSTANCE.scheduleCyclic(() -> DungeonMapLabels.updateRoomNames(null), 20);
    }

    private static boolean shouldProcess() {
        return Utils.isInDungeons() && DungeonScore.isDungeonStarted() && !DungeonManager.isInBoss() && SkyblockerConfigManager.get().dungeons.dungeonMap.showRoomLabels;
    }

    private static void clearLabels() {
        if (!LABELS.isEmpty()) {
            LABELS.clear();
        }
    }

    private static void onRoomMatched(Room room) {
        DungeonMapLabels.updateRoomNames(room);
    }

    private static void updateRoomNames(@Nullable Room newRoom) {
        if (!DungeonMapLabels.shouldProcess()) {
            return;
        }
        Vector2ic entrancePos = DungeonManager.getPhysicalEntrancePos();
        Vector2ic mapEntrancePos = DungeonManager.getMapEntrancePos();
        if (entrancePos == null || mapEntrancePos == null) {
            return;
        }
        int mapRoomSize = DungeonManager.getMapRoomSize();
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (newRoom != null) {
            DungeonMapLabels.addRoomLabel(newRoom, entrancePos, mapEntrancePos, mapRoomSize, textRenderer);
            return;
        }
        LABELS.clear();
        DungeonManager.getRoomsStream().filter(Room::isMatched).forEach(room -> DungeonMapLabels.addRoomLabel(room, entrancePos, mapEntrancePos, mapRoomSize, textRenderer));
    }

    private static void addRoomLabel(Room room, Vector2ic entrancePos, Vector2ic mapEntrancePos, int mapRoomSize, class_327 textRenderer) {
        int n;
        if (LABELS.containsKey((Object)room.getName())) {
            return;
        }
        Objects.requireNonNull(textRenderer);
        class_243 labelPos = DungeonMapLabels.getPosForLabel(room, mapRoomSize, 9);
        if (labelPos == null) {
            return;
        }
        Vector2dc mapPos = DungeonMapUtils.getMapPosFromPhysical(entrancePos, mapEntrancePos, mapRoomSize, (class_2374)labelPos);
        DungeonManager.RoomInfo roomInfo = DungeonManager.getRoomMetadata(room.getName());
        if (roomInfo == null) {
            return;
        }
        String roomName = roomInfo.name();
        Room room2 = room;
        Objects.requireNonNull(room2);
        Room room3 = room2;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Room.class, Room.class}, (Object)room3, n2)) {
                case 0: {
                    Room r = room3;
                    if (!r.greenChecked) {
                        n2 = 1;
                        continue block4;
                    }
                    n = -16711936;
                    break block4;
                }
                case 1: {
                    Room r = room3;
                    if (!r.whiteChecked) {
                        n2 = 2;
                        continue block4;
                    }
                    n = -1;
                    break block4;
                }
                default: {
                    n = -8355712;
                    break block4;
                }
            }
            break;
        }
        int color = n;
        float width = (float)DungeonMapLabels.getMaxWidth(room, mapRoomSize) / 0.55f;
        class_5250 text = class_2561.method_43470((String)roomName);
        List lines = textRenderer.method_1728((class_5348)text, (int)width);
        LABELS.put((Object)room.getName(), (Object)new RoomLabel(lines, (int)mapPos.x(), (int)mapPos.y(), color));
    }

    protected static void renderRoomNames(class_332 context) {
        if (!SkyblockerConfigManager.get().dungeons.dungeonMap.showRoomLabels) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        for (RoomLabel label : LABELS.values()) {
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)label.x, (float)label.y);
            context.method_51448().scale(0.55f);
            DungeonMapLabels.drawText(context, textRenderer, label.textLines, label.color);
            context.method_51448().popMatrix();
        }
    }

    private static class_243 getPosForLabel(Room room, int mapRoomSize, int fontHeight) {
        switch (room.getType()) {
            case BLOOD: 
            case FAIRY: {
                return null;
            }
        }
        Set<Vector2ic> segments = room.getSegments();
        int[] segmentsX = segments.stream().mapToInt(Vector2ic::x).sorted().toArray();
        int[] segmentsY = segments.stream().mapToInt(Vector2ic::y).sorted().toArray();
        Vector2i result = null;
        switch (room.getShape()) {
            case TRAP: 
            case PUZZLE: 
            case MINIBOSS: 
            case ONE_BY_ONE: {
                result = new Vector2i(segmentsX[0] + mapRoomSize - 2, (int)((double)(segmentsY[0] + mapRoomSize) - (double)fontHeight / 2.0 + 1.0));
                if (mapRoomSize != 18) break;
                result.x -= 2;
                break;
            }
            case L_SHAPE: {
                int medY = segmentsY[1] + mapRoomSize - 2;
                int medX = room.getDirection() == Room.Direction.SE || room.getDirection() == Room.Direction.SW ? segmentsX[1] - 2 : segmentsX[2] - mapRoomSize / 4 + 2;
                result = new Vector2i(medX, medY);
                break;
            }
            case TWO_BY_TWO: 
            case ONE_BY_TWO: 
            case ONE_BY_THREE: 
            case ONE_BY_FOUR: {
                int avgX = (segmentsX[0] + segmentsX[segmentsX.length - 1] + mapRoomSize) / 2;
                avgX = room.getDirection() == Room.Direction.SE || room.getDirection() == Room.Direction.SW ? (avgX += mapRoomSize / 2) : (avgX += mapRoomSize / 4 + 1);
                int avgY = (segmentsY[0] + segmentsY[segmentsY.length - 1] + mapRoomSize) / 2 + mapRoomSize / 3 + 2;
                result = new Vector2i(avgX, avgY);
            }
        }
        result.sub(0, fontHeight / 2, result);
        return new class_243((double)result.x(), 0.0, (double)result.y());
    }

    private static int getMaxWidth(Room room, int mapRoomSize) {
        int maxWidth = switch (room.getShape()) {
            default -> throw new MatchException(null, null);
            case Room.Shape.ONE_BY_ONE -> {
                if (mapRoomSize == 16) {
                    yield mapRoomSize + 2;
                }
                yield mapRoomSize;
            }
            case Room.Shape.TRAP, Room.Shape.PUZZLE, Room.Shape.MINIBOSS -> mapRoomSize;
            case Room.Shape.ONE_BY_TWO, Room.Shape.ONE_BY_THREE, Room.Shape.ONE_BY_FOUR -> {
                if (room.getDirection() == Room.Direction.NE) {
                    yield mapRoomSize;
                }
                yield mapRoomSize * 3;
            }
            case Room.Shape.L_SHAPE, Room.Shape.TWO_BY_TWO -> mapRoomSize * 2;
        };
        return (int)((float)maxWidth * 1.5f);
    }

    private static void drawText(class_332 context, class_327 textRenderer, List<class_5481> lines, int color) {
        int n;
        if (lines.size() > 1) {
            Objects.requireNonNull(textRenderer);
            n = -(9 / 2) * (lines.size() - 1);
        } else {
            n = 0;
        }
        int y = n;
        for (class_5481 orderedText : lines) {
            int textWidth = textRenderer.method_30880(orderedText) / 2;
            HudHelper.drawOutlinedText(context, orderedText, -textWidth, y, color, -16777216);
            y += 9;
        }
    }

    private record RoomLabel(List<class_5481> textLines, int x, int y, int color) {
    }
}

