/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.partyfinder;

import de.hysky.skyblocker.skyblock.dungeon.partyfinder.OptionDropdownWidget;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.PartyFinderScreen;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.RangedValueWidget;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_9017;

public class FinderSettingsContainer
extends class_9017 {
    private boolean isInitialized = false;
    private OptionDropdownWidget floorSelector;
    private OptionDropdownWidget dungeonTypeSelector;
    private OptionDropdownWidget sortGroupsSelector;
    private RangedValueWidget classLevelRange;
    private RangedValueWidget dungeonLevelRange;
    private class_9017 currentlyOpenedOption = null;
    private final List<class_9017> initializedWidgets = new ArrayList<class_9017>();

    public FinderSettingsContainer(int x, int y, int height) {
        super(x, y, 336, height, (class_2561)class_2561.method_43473());
    }

    public void method_55444(int width, int height, int x, int y) {
        super.method_55444(width, height, x, y);
        if (this.floorSelector != null) {
            this.floorSelector.method_48229(x + width / 4 - 70, y + 20);
        }
        if (this.dungeonTypeSelector != null) {
            this.dungeonTypeSelector.method_48229(x + 3 * width / 4 - 70, y + 20);
        }
        if (this.sortGroupsSelector != null) {
            this.sortGroupsSelector.method_48229(x + width / 2 - 70, y + 120);
        }
        if (this.classLevelRange != null) {
            this.classLevelRange.method_48229(x + width / 4 - 50, y + 70);
        }
        if (this.dungeonLevelRange != null) {
            this.dungeonLevelRange.method_48229(x + 3 * width / 4 - 50, y + 70);
        }
    }

    public boolean handle(PartyFinderScreen screen, String inventoryName) {
        String nameLowerCase = inventoryName.toLowerCase(Locale.ENGLISH);
        class_1707 handler = screen.getHandler();
        if (!this.isInitialized) {
            if (!nameLowerCase.contains("search settings")) {
                return false;
            }
            this.isInitialized = true;
            for (class_1735 slot : handler.field_7761) {
                if (slot.field_7874 > handler.method_17388() * 9 - 1) break;
                if (!slot.method_7681()) continue;
                class_1799 stack = slot.method_7677();
                String name = stack.method_7964().getString().toLowerCase(Locale.ENGLISH);
                if (name.contains("floor")) {
                    this.floorSelector = new OptionDropdownWidget(screen, stack.method_7964(), null, this.method_46426() + this.method_25368() / 4 - 70, this.method_46427() + 20, 140, 170, slot.field_7874);
                    if (!this.setSelectedElementFromTooltip(slot, stack, this.floorSelector)) {
                        return false;
                    }
                    this.initializedWidgets.add((class_9017)this.floorSelector);
                    continue;
                }
                if (name.contains("dungeon type")) {
                    this.dungeonTypeSelector = new OptionDropdownWidget(screen, stack.method_7964(), null, this.method_46426() + 3 * this.method_25368() / 4 - 70, this.method_46427() + 20, 140, 100, slot.field_7874);
                    if (!this.setSelectedElementFromTooltip(slot, stack, this.dungeonTypeSelector)) {
                        return false;
                    }
                    this.initializedWidgets.add((class_9017)this.dungeonTypeSelector);
                    continue;
                }
                if (name.contains("groups")) {
                    this.sortGroupsSelector = new OptionDropdownWidget(screen, stack.method_7964(), null, this.method_46426() + this.method_25368() / 2 - 70, this.method_46427() + 120, 140, 100, slot.field_7874);
                    if (!this.setSelectedElementFromTooltip(slot, stack, this.sortGroupsSelector)) {
                        return false;
                    }
                    this.initializedWidgets.add((class_9017)this.sortGroupsSelector);
                    continue;
                }
                if (name.contains("class level")) {
                    this.classLevelRange = new RangedValueWidget(screen, stack.method_7964(), this.method_46426() + this.method_25368() / 4 - 50, this.method_46427() + 70, 100, slot.field_7874);
                    if (!this.setRangeFromTooltip(stack, this.classLevelRange)) {
                        return false;
                    }
                    this.initializedWidgets.add(this.classLevelRange);
                    continue;
                }
                if (!name.contains("dungeon level")) continue;
                this.dungeonLevelRange = new RangedValueWidget(screen, stack.method_7964(), this.method_46426() + 3 * this.method_25368() / 4 - 50, this.method_46427() + 70, 100, slot.field_7874);
                if (!this.setRangeFromTooltip(stack, this.dungeonLevelRange)) {
                    return false;
                }
                this.initializedWidgets.add(this.dungeonLevelRange);
            }
        }
        if (nameLowerCase.contains("search settings")) {
            if (this.floorSelector != null) {
                this.floorSelector.close();
            }
            if (this.dungeonTypeSelector != null) {
                this.dungeonTypeSelector.close();
            }
            if (this.sortGroupsSelector != null) {
                this.sortGroupsSelector.close();
            }
            if (this.classLevelRange != null) {
                this.classLevelRange.setState(RangedValueWidget.State.CLOSED);
            }
            if (this.dungeonLevelRange != null) {
                this.dungeonLevelRange.setState(RangedValueWidget.State.CLOSED);
            }
            screen.partyFinderButton.field_22763 = true;
            this.currentlyOpenedOption = null;
            for (int i = (handler.method_17388() - 1) * 9; i < handler.method_17388() * 9; ++i) {
                class_1735 slot;
                slot = (class_1735)handler.field_7761.get(i);
                if (!slot.method_7681() || !slot.method_7677().method_31574(class_1802.field_8107)) continue;
                screen.partyButtonSlotId = slot.field_7874;
            }
            return true;
        }
        screen.partyFinderButton.field_22763 = false;
        if (nameLowerCase.contains("floor")) {
            this.updateDropdownOptionWidget(handler, this.floorSelector);
            return true;
        }
        if (nameLowerCase.contains("select type")) {
            this.updateDropdownOptionWidget(handler, this.dungeonTypeSelector);
            return true;
        }
        if (nameLowerCase.contains("class level range")) {
            this.updateRangedValue(handler, this.classLevelRange);
            return true;
        }
        if (nameLowerCase.contains("dungeon level range")) {
            this.updateRangedValue(handler, this.dungeonLevelRange);
            return true;
        }
        if (nameLowerCase.contains("sort")) {
            this.updateDropdownOptionWidget(handler, this.sortGroupsSelector);
            return true;
        }
        return false;
    }

    private int findBackSlotId(class_1707 handler) {
        int backId = -1;
        for (int i = (handler.method_17388() - 1) * 9; i < handler.method_17388() * 9; ++i) {
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (!slot.method_7681() || !slot.method_7677().method_31574(class_1802.field_8107)) continue;
            backId = slot.field_7874;
            break;
        }
        return backId;
    }

    private boolean setRangeFromTooltip(class_1799 stack, RangedValueWidget widget) {
        for (class_2561 text : ItemUtils.getLore(stack)) {
            String textLowerCase = text.getString().toLowerCase(Locale.ENGLISH);
            if (!textLowerCase.contains("selected:")) continue;
            String[] split = text.getString().split(":");
            if (split.length < 2) {
                return false;
            }
            String[] minAndMax = split[1].split("-");
            if (minAndMax.length < 2) {
                return false;
            }
            int leMin = -1;
            int leMax = -1;
            try {
                leMin = Integer.parseInt(minAndMax[0].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                leMax = Integer.parseInt(minAndMax[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            widget.setMinAndMax(leMin, leMax);
            return true;
        }
        return false;
    }

    private boolean setSelectedElementFromTooltip(class_1735 slot, class_1799 stack, OptionDropdownWidget dropdownWidget) {
        for (class_2561 text : ItemUtils.getLore(stack)) {
            String textLowerCase = text.getString().toLowerCase(Locale.ENGLISH);
            if (!textLowerCase.contains("selected:")) continue;
            String[] split = text.getString().split(":");
            if (split.length < 2) {
                return false;
            }
            String floorName = split[1].trim();
            OptionDropdownWidget optionDropdownWidget = dropdownWidget;
            Objects.requireNonNull(optionDropdownWidget);
            dropdownWidget.setSelectedOption(new OptionDropdownWidget.Option(optionDropdownWidget, floorName, stack, slot.field_7874));
            return true;
        }
        return false;
    }

    public boolean handleSign(class_2625 sign, boolean front) {
        if (!this.isInitialized) {
            return false;
        }
        if (this.currentlyOpenedOption == this.classLevelRange) {
            return this.updateValues(sign, front, this.classLevelRange);
        }
        if (this.currentlyOpenedOption == this.dungeonLevelRange) {
            return this.updateValues(sign, front, this.dungeonLevelRange);
        }
        return false;
    }

    private boolean updateValues(class_2625 sign, boolean front, RangedValueWidget valueWidget) {
        RangedValueWidget.State state;
        String lowerCase = sign.method_49843(front).method_49859(3, false).getString().toLowerCase(Locale.ENGLISH);
        if (lowerCase.contains("max")) {
            state = RangedValueWidget.State.MODIFYING_MAX;
        } else if (lowerCase.contains("min")) {
            state = RangedValueWidget.State.MODIFYING_MIN;
        } else {
            return false;
        }
        valueWidget.setState(state);
        this.method_25395((class_364)valueWidget);
        return true;
    }

    private void updateDropdownOptionWidget(class_1707 handler, OptionDropdownWidget dropdownWidget) {
        this.currentlyOpenedOption = dropdownWidget;
        ArrayList<OptionDropdownWidget.Option> entries = new ArrayList<OptionDropdownWidget.Option>();
        for (class_1735 slot : handler.field_7761) {
            if (slot.field_7874 > (handler.method_17388() - 1) * 9 - 1) break;
            if (!slot.method_7681() || slot.method_7677().method_31574(class_1802.field_8157)) continue;
            OptionDropdownWidget optionDropdownWidget = dropdownWidget;
            Objects.requireNonNull(optionDropdownWidget);
            entries.add(new OptionDropdownWidget.Option(optionDropdownWidget, slot.method_7677().method_7964().getString(), slot.method_7677(), slot.field_7874));
        }
        int backId = this.findBackSlotId(handler);
        dropdownWidget.open(entries, backId);
    }

    private void updateRangedValue(class_1707 handler, RangedValueWidget valueWidget) {
        this.currentlyOpenedOption = valueWidget;
        int min = -1;
        int max = -1;
        for (class_1735 slot : handler.field_7761) {
            if (slot.field_7874 > (handler.method_17388() - 1) * 9 - 1) break;
            if (slot.method_7681() && slot.method_7677().method_7964().getString().toLowerCase(Locale.ENGLISH).contains("min")) {
                min = slot.field_7874;
                continue;
            }
            if (!slot.method_7681() || !slot.method_7677().method_7964().getString().toLowerCase(Locale.ENGLISH).contains("max")) continue;
            max = slot.field_7874;
        }
        int backId = this.findBackSlotId(handler);
        valueWidget.setStateAndSlots(RangedValueWidget.State.OPEN, min, max, backId);
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
        if (this.floorSelector != null) {
            this.floorSelector.field_22764 = visible;
        }
        if (this.dungeonTypeSelector != null) {
            this.dungeonTypeSelector.field_22764 = visible;
        }
        if (this.classLevelRange != null) {
            this.classLevelRange.field_22764 = visible;
        }
        if (this.dungeonLevelRange != null) {
            this.dungeonLevelRange.field_22764 = visible;
        }
        if (this.sortGroupsSelector != null) {
            this.sortGroupsSelector.field_22764 = visible;
        }
    }

    public boolean canInteract(class_9017 widget) {
        return this.currentlyOpenedOption == null || this.currentlyOpenedOption == widget;
    }

    public boolean hasOpenOption() {
        return this.currentlyOpenedOption != null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hasOpenOption()) {
            return this.currentlyOpenedOption.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764 || !this.isInitialized) {
            return;
        }
        this.classLevelRange.method_25394(context, mouseX, mouseY, delta);
        this.dungeonLevelRange.method_25394(context, mouseX, mouseY, delta);
        this.sortGroupsSelector.method_25394(context, mouseX, mouseY, delta);
        this.floorSelector.method_25394(context, mouseX, mouseY, delta);
        this.dungeonTypeSelector.method_25394(context, mouseX, mouseY, delta);
    }

    public List<? extends class_364> method_25396() {
        return this.initializedWidgets;
    }

    protected void method_47399(class_6382 builder) {
    }

    protected int method_44395() {
        return 0;
    }

    protected double method_44393() {
        return 0.0;
    }
}

