/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import com.google.common.primitives.Booleans;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class IceFill
extends DungeonPuzzle {
    public static final IceFill INSTANCE = new IceFill();
    private static final float[] RED_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7964);
    private static final class_2338[] BOARD_ORIGINS = new class_2338[]{new class_2338(16, 70, 9), new class_2338(17, 71, 16), new class_2338(18, 72, 25)};
    private CompletableFuture<Void> solve;
    private final boolean[][][] iceFillBoards = new boolean[][][]{new boolean[3][3], new boolean[5][5], new boolean[7][7]};
    private final List<List<Vector2ic>> iceFillPaths = new ArrayList<List<List<Vector2ic>>>(List.of(List.of(), List.of(), List.of()));

    private IceFill() {
        super("ice-fill", "ice-path");
    }

    @Init
    public static void init() {
        if (Debug.debugEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"puzzle").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)IceFill.INSTANCE.puzzleName).then(ClientCommandManager.literal((String)"printBoard1").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.boardToString(IceFill.INSTANCE.iceFillBoards[0])));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printBoard2").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.boardToString(IceFill.INSTANCE.iceFillBoards[1])));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printBoard3").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.boardToString(IceFill.INSTANCE.iceFillBoards[2])));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printPath1").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.INSTANCE.iceFillPaths.getFirst().toString()));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printPath2").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.INSTANCE.iceFillPaths.get(1).toString()));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printPath3").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(IceFill.INSTANCE.iceFillPaths.get(2).toString()));
                return 1;
            })))))));
        }
    }

    private static String boardToString(boolean[][] iceFillBoard) {
        StringBuilder sb = new StringBuilder();
        for (boolean[] row : iceFillBoard) {
            sb.append("\n");
            for (boolean cell : row) {
                sb.append(cell ? (char)'#' : '.');
            }
        }
        return sb.toString();
    }

    @Override
    public void tick(class_310 client) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveIceFill || client.field_1687 == null || !DungeonManager.isCurrentRoomMatched() || this.solve != null && !this.solve.isDone()) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        this.solve = CompletableFuture.runAsync(() -> {
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int i = 0; i < 3; ++i) {
                if (!this.updateBoard((class_1937)client.field_1687, room, this.iceFillBoards[i], pos.method_10101((class_2382)BOARD_ORIGINS[i]))) continue;
                this.iceFillPaths.set(i, this.solve(this.iceFillBoards[i]));
            }
        });
    }

    private boolean updateBoard(class_1937 world, Room room, boolean[][] iceFillBoard, class_2338.class_2339 pos) {
        boolean boardChanged = false;
        for (int row = 0; row < iceFillBoard.length; ++row) {
            for (int col = 0; col < iceFillBoard[row].length; ++col) {
                boolean isBlock;
                class_2338 actualPos = room.relativeToActual((class_2338)pos);
                if (world.method_8320(actualPos.method_10074()).method_26215()) {
                    return false;
                }
                boolean bl = isBlock = !world.method_8320(actualPos).method_26215();
                if (iceFillBoard[row][col] != isBlock) {
                    iceFillBoard[row][col] = isBlock;
                    boardChanged = true;
                }
                pos.method_10098(class_2350.field_11039);
            }
            pos.method_10100(iceFillBoard[row].length, 0, -1);
        }
        return boardChanged;
    }

    @NotNull
    List<Vector2ic> solve(boolean[][] iceFillBoard) {
        Vector2i start = new Vector2i(iceFillBoard.length - 1, iceFillBoard[0].length / 2);
        int count = iceFillBoard.length * iceFillBoard[0].length - Arrays.stream(iceFillBoard).mapToInt(Booleans::countTrue).sum();
        boolean[][] visited = new boolean[iceFillBoard.length][iceFillBoard[0].length];
        visited[start.x()][start.y()] = true;
        List<Vector2ic> newPath = this.solveDfs(iceFillBoard, count - 1, new ArrayList<Vector2i>(List.of(start)), visited);
        return newPath != null ? newPath : List.of();
    }

    @Nullable
    private List<Vector2ic> solveDfs(boolean[][] iceFillBoard, int count, List<Vector2ic> path, boolean[][] visited) {
        Vector2ic[] newPosArray;
        Vector2ic pos = path.getLast();
        if (count == 0) {
            if (pos.x() == 0 && pos.y() == iceFillBoard[0].length / 2) {
                return path;
            }
            return null;
        }
        for (Vector2ic newPos : newPosArray = new Vector2ic[]{pos.add(1, 0, new Vector2i()), pos.add(-1, 0, new Vector2i()), pos.add(0, 1, new Vector2i()), pos.add(0, -1, new Vector2i())}) {
            if (newPos.x() < 0 || newPos.x() >= iceFillBoard.length || newPos.y() < 0 || newPos.y() >= iceFillBoard[0].length || iceFillBoard[newPos.x()][newPos.y()] || visited[newPos.x()][newPos.y()]) continue;
            path.add(newPos);
            visited[newPos.x()][newPos.y()] = true;
            List<Vector2ic> newPath = this.solveDfs(iceFillBoard, count - 1, path, visited);
            if (newPath != null) {
                return newPath;
            }
            path.removeLast();
            visited[newPos.x()][newPos.y()] = false;
        }
        return null;
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveIceFill || !DungeonManager.isCurrentRoomMatched()) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        for (int i = 0; i < 3; ++i) {
            this.extractPath(collector, room, this.iceFillPaths.get(i), BOARD_ORIGINS[i]);
        }
    }

    private void extractPath(PrimitiveCollector collector, Room room, List<Vector2ic> iceFillPath, class_2338 originPos) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = 0; i < iceFillPath.size() - 1; ++i) {
            class_243 start = class_243.method_24953((class_2382)room.relativeToActual((class_2338)pos.method_10101((class_2382)originPos).method_10100(-iceFillPath.get(i).y(), 0, -iceFillPath.get(i).x())));
            class_243 end = class_243.method_24953((class_2382)room.relativeToActual((class_2338)pos.method_10101((class_2382)originPos).method_10100(-iceFillPath.get(i + 1).y(), 0, -iceFillPath.get(i + 1).x())));
            collector.submitLinesFromPoints(new class_243[]{start, end}, RED_COLOR_COMPONENTS, 1.0f, 5.0f, true);
        }
    }
}

